/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.crafting;

import com.sk89q.craftbook.BaseConfiguration;
import com.sk89q.craftbook.mech.crafting.CraftingItemStack;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipeManager
extends BaseConfiguration {
    public static RecipeManager INSTANCE;
    private final Collection<Recipe> recipes = new ArrayList<Recipe>();
    private final File config;

    public RecipeManager(FileConfiguration cfg, File dataFolder) {
        super(cfg, dataFolder);
        this.config = new File(dataFolder, "crafting-recipes.yml");
        this.load(cfg.getConfigurationSection("crafting-recipes"));
        INSTANCE = this;
    }

    public Collection<Recipe> getRecipes() {
        return this.recipes;
    }

    public void reload() {
        this.recipes.clear();
        this.load(YamlConfiguration.loadConfiguration((File)this.config).getConfigurationSection("crafting-recipes"));
    }

    private void load(ConfigurationSection cfg) {
        if (cfg == null) {
            return;
        }
        Set keys = cfg.getKeys(false);
        if (keys != null) {
            for (String key : keys) {
                this.recipes.add(new Recipe(key, cfg));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Recipe {
        private final String id;
        private final ConfigurationSection config;
        private RecipeType type;
        private Collection<CraftingItemStack> ingredients;
        private Collection<CraftingItemStack> results;

        private Recipe(String id, ConfigurationSection cfg) {
            this.id = id;
            this.config = cfg.getConfigurationSection(id);
            this.ingredients = new ArrayList<CraftingItemStack>();
            this.results = new ArrayList<CraftingItemStack>();
            this.load();
        }

        private void load() {
            this.type = RecipeType.getTypeFromName(this.config.getString("type"));
            this.ingredients = this.getItems(this.config.getConfigurationSection("ingredients"));
            this.results = this.getItems(this.config.getConfigurationSection("results"));
        }

        private Collection<CraftingItemStack> getItems(ConfigurationSection section) {
            ArrayList<CraftingItemStack> items = new ArrayList<CraftingItemStack>();
            for (String item : section.getKeys(false)) {
                Material material;
                String[] split = item.split(":");
                try {
                    material = Material.getMaterial((int)Integer.parseInt(split[0]));
                }
                catch (NumberFormatException e) {
                    material = Material.getMaterial((String)split[0].toUpperCase());
                }
                if (material == null) continue;
                CraftingItemStack itemStack = new CraftingItemStack(material);
                if (split.length > 1) {
                    itemStack.setData(Short.parseShort(split[1]));
                } else {
                    itemStack.setData((short)-1);
                }
                itemStack.setAmount(section.getInt(item, 1));
                items.add(itemStack);
            }
            return items;
        }

        public String getId() {
            return this.id;
        }

        public RecipeType getType() {
            return this.type;
        }

        public Collection<CraftingItemStack> getIngredients() {
            return this.ingredients;
        }

        public CraftingItemStack getResult() {
            try {
                return this.results.iterator().next();
            }
            catch (Exception e) {
                return null;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum RecipeType {
            SHAPELESS("Shapeless"),
            SHAPED3X3("Shaped3x3"),
            SHAPED2X2("Shaped2x2"),
            FURNACE("Furnace");

            private String name;

            private RecipeType(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }

            public static RecipeType getTypeFromName(String name) {
                for (RecipeType t : RecipeType.values()) {
                    if (!t.getName().equalsIgnoreCase(name)) continue;
                    return t;
                }
                return SHAPELESS;
            }
        }
    }
}

