/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.mech.dispenser;

import com.sk89q.craftbook.bukkit.MechanismsPlugin;
import com.sk89q.craftbook.mech.dispenser.Fan;
import com.sk89q.craftbook.mech.dispenser.FireArrows;
import com.sk89q.craftbook.mech.dispenser.Recipe;
import com.sk89q.craftbook.mech.dispenser.SnowShooter;
import com.sk89q.craftbook.mech.dispenser.XPShooter;
import com.sk89q.craftbook.util.ItemUtil;
import java.util.ArrayList;
import org.bukkit.block.Dispenser;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenserRecipes
implements Listener {
    final MechanismsPlugin plugin;
    final ArrayList<Recipe> recipes = new ArrayList();

    public DispenserRecipes(MechanismsPlugin plugin) {
        this.plugin = plugin;
        this.addRecipe(new XPShooter());
        this.addRecipe(new SnowShooter());
        this.addRecipe(new FireArrows());
        this.addRecipe(new Fan());
    }

    @EventHandler
    public void onBlockDispense(BlockDispenseEvent event) {
        Dispenser dis;
        if (event.isCancelled()) {
            return;
        }
        if (event.getBlock().getState() instanceof Dispenser && this.plugin.getLocalConfiguration().dispenserSettings.enable && this.dispenseNew(dis = (Dispenser)event.getBlock().getState(), event.getItem(), event.getVelocity(), event)) {
            event.setCancelled(true);
        }
    }

    private boolean dispenseNew(Dispenser dis, ItemStack item, Vector velocity, BlockDispenseEvent event) {
        if (dis == null || dis.getInventory() == null || dis.getInventory().getContents() == null) {
            return false;
        }
        ItemStack[] stacks = dis.getInventory().getContents();
        boolean toReturn = false;
        try {
            block2: for (Recipe r : this.recipes) {
                int i;
                if (r == null) {
                    this.recipes.remove(r);
                    continue;
                }
                if ((r.recipe[0] != 0 || stacks[0] != null) && r.recipe[0] != stacks[0].getTypeId()) continue;
                for (i = 1; i < stacks.length; ++i) {
                    if (r.recipe[i] != 0 && stacks[i] == null || (r.recipe[i] != 0 || stacks[i] != null) && r.recipe[i] != stacks[i].getTypeId()) continue block2;
                }
                toReturn = r.doAction(dis, item, velocity, event);
                for (i = 1; i < stacks.length; ++i) {
                    if (r.recipe[i] == 0 && stacks[i] == null || r.recipe[i] == stacks[i].getTypeId()) {
                        if (stacks[i] == null || stacks[i].getTypeId() == 0 || r.recipe[i] == 0) continue;
                        stacks[i] = ItemUtil.getUsedItem((ItemStack)stacks[i]);
                        continue;
                    }
                    return true;
                }
                dis.getInventory().setContents(stacks);
            }
            return toReturn;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void addRecipe(Recipe recipe) {
        if (this.recipes.contains(recipe)) {
            return;
        }
        this.recipes.add(recipe);
    }
}

