/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.bukkit;

import com.sk89q.craftbook.InsufficientPermissionsException;
import com.sk89q.craftbook.LanguageManager;
import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.VehiclesConfiguration;
import com.sk89q.craftbook.bukkit.BaseBukkitPlugin;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.MinecartManager;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Boat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.vehicle.VehicleCreateEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleExitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class VehiclesPlugin
extends BaseBukkitPlugin {
    private VehiclesConfiguration config;
    private MinecartManager cartman;

    public void onEnable() {
        super.onEnable();
        this.createDefaultConfiguration("config.yml", false);
        this.config = new VehiclesConfiguration(this.getConfig(), this.getDataFolder());
        this.saveConfig();
        this.languageManager = new LanguageManager((BaseBukkitPlugin)this);
        this.cartman = new MinecartManager(this);
        this.registerEvents();
    }

    protected void registerEvents() {
        this.getServer().getPluginManager().registerEvents((Listener)new CraftBookVehicleListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new CraftBookVehicleBlockListener(this), (Plugin)this);
    }

    public VehiclesConfiguration getLocalConfiguration() {
        return this.config;
    }

    class Decay
    implements Runnable {
        Minecart cart;

        public Decay(Minecart cart) {
            this.cart = cart;
        }

        public void run() {
            if (this.cart.isEmpty()) {
                this.cart.setDamage(41);
            }
        }
    }

    class CraftBookVehicleBlockListener
    implements Listener {
        VehiclesPlugin plugin;

        public CraftBookVehicleBlockListener(VehiclesPlugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onBlockRedstoneChange(BlockRedstoneEvent event) {
            if (event.getOldCurrent() > 0 == event.getNewCurrent() > 0) {
                return;
            }
            for (BlockFace bf : CartMechanism.powerSupplyOptions) {
                VehiclesPlugin.this.cartman.impact((BlockRedstoneEvent)new SourcedBlockRedstoneEvent(event, event.getBlock().getRelative(bf)));
            }
        }

        @EventHandler
        public void onChunkLoad(ChunkLoadEvent event) {
            if (((VehiclesPlugin)VehiclesPlugin.this).config.minecartDecayWhenEmpty) {
                for (Entity ent : event.getChunk().getEntities()) {
                    if (ent == null || ent.isDead() || !(ent instanceof Minecart) || !ent.isEmpty()) continue;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Decay((Minecart)ent), (long)((VehiclesPlugin)VehiclesPlugin.this).config.minecartDecayTime);
                }
            }
        }

        @EventHandler
        public void onSignChange(SignChangeEvent event) {
            Block block = event.getBlock();
            String[] lines = event.getLines();
            LocalPlayer player = VehiclesPlugin.this.wrap(event.getPlayer());
            try {
                if (lines[1].equalsIgnoreCase("[deposit]") || lines[1].equalsIgnoreCase("[collect]")) {
                    player.checkPermission("craftbook.vehicles.deposit");
                } else if (lines[1].equalsIgnoreCase("[dispenser]")) {
                    player.checkPermission("craftbook.vehicles.dispenser");
                } else if (lines[1].equalsIgnoreCase("[eject]")) {
                    player.checkPermission("craftbook.vehicles.eject");
                } else if (lines[1].equalsIgnoreCase("[print]")) {
                    player.checkPermission("craftbook.vehicles.print");
                } else if (lines[1].equalsIgnoreCase("[reverse]")) {
                    player.checkPermission("craftbook.vehicles.reverse");
                } else if (lines[1].equalsIgnoreCase("[sort]")) {
                    player.checkPermission("craftbook.vehicles.sort");
                } else if (lines[1].equalsIgnoreCase("[station]")) {
                    player.checkPermission("craftbook.vehicles.station");
                } else if (lines[1].equalsIgnoreCase("[teleport]")) {
                    player.checkPermission("craftbook.vehicles.teleport");
                }
            }
            catch (InsufficientPermissionsException e) {
                player.printError("vehicles.create-permission");
                block.breakNaturally();
                event.setCancelled(true);
            }
        }
    }

    class CraftBookVehicleListener
    implements Listener {
        VehiclesPlugin plugin;

        public CraftBookVehicleListener(VehiclesPlugin plugin) {
            this.plugin = plugin;
        }

        @EventHandler
        public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            Vehicle vehicle = event.getVehicle();
            Entity entity = event.getEntity();
            if (entity instanceof Player) {
                return;
            }
            if (!(config.boatRemoveEntities || config.minecartRemoveEntities || config.minecartEnterOnImpact)) {
                return;
            }
            if (config.minecartEnterOnImpact && vehicle instanceof Minecart) {
                if (!vehicle.isEmpty()) {
                    return;
                }
                if (!(event.getEntity() instanceof LivingEntity)) {
                    return;
                }
                vehicle.setPassenger(event.getEntity());
                return;
            }
            if (config.boatRemoveEntities && vehicle instanceof Boat) {
                if (!config.boatRemoveEntitiesOtherBoats && entity instanceof Boat) {
                    return;
                }
                entity.remove();
                return;
            }
            if (config.minecartRemoveEntities && vehicle instanceof Minecart) {
                if (!config.minecartRemoveEntitiesOtherCarts && entity instanceof Minecart) {
                    return;
                }
                entity.remove();
            }
        }

        @EventHandler
        public void onVehicleCreate(VehicleCreateEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            Minecart minecart = (Minecart)vehicle;
            minecart.setSlowWhenEmpty(config.minecartSlowWhenEmpty);
            minecart.setMaxSpeed(minecart.getMaxSpeed() * config.minecartMaxSpeedModifier);
        }

        @EventHandler
        public void onVehicleEnter(VehicleEnterEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesPlugin.this.cartman.enter(event);
        }

        @EventHandler
        public void onVehicleExit(VehicleExitEvent event) {
            Vehicle vehicle = event.getVehicle();
            if (!(vehicle instanceof Minecart)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            if (config.minecartRemoveOnExit) {
                vehicle.remove();
            } else if (config.minecartDecayWhenEmpty) {
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new Decay((Minecart)vehicle), (long)config.minecartDecayTime);
            }
        }

        @EventHandler
        public void onVehicleMove(VehicleMoveEvent event) {
            if (!(event.getVehicle() instanceof Minecart)) {
                return;
            }
            VehiclesPlugin.this.cartman.impact(event);
        }

        @EventHandler
        public void onVehicleDestroy(VehicleDestroyEvent event) {
            if (!(event.getVehicle() instanceof Boat)) {
                return;
            }
            VehiclesConfiguration config = VehiclesPlugin.this.getLocalConfiguration();
            if (config.boatNoCrash && event.getAttacker() == null) {
                event.getVehicle().setVelocity(new Vector(0, 0, 0));
                event.setCancelled(true);
            } else if (config.boatBreakReturn && event.getAttacker() == null) {
                Boat boat = (Boat)event.getVehicle();
                boat.getLocation().getWorld().dropItemNaturally(boat.getLocation(), new ItemStack(333));
                boat.remove();
                event.setCancelled(true);
            }
        }
    }
}

