/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.RailUtil;
import com.sk89q.craftbook.RedstoneUtil;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.worldedit.blocks.ItemType;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.block.Chest;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CartDispenser
extends CartMechanism {
    public void impact(Minecart cart, CartMechanismBlocks blocks, boolean minor) {
        if (minor) {
            return;
        }
        if (!blocks.matches("dispenser")) {
            return;
        }
        RedstoneUtil.Power pow = this.isActive(blocks.rail, blocks.base, blocks.sign);
        boolean inf = "inf".equalsIgnoreCase(blocks.getSign().getLine(2));
        for (Chest c : RailUtil.getNearbyChests(blocks.base)) {
            Inventory inv = inf ? null : c.getInventory();
            CartType type = CartType.fromString(blocks.getSign().getLine(3));
            if (cart == null) {
                switch (pow) {
                    case ON: {
                        this.dispense(blocks, inv, type);
                        return;
                    }
                }
                continue;
            }
            switch (pow) {
                case ON: {
                    return;
                }
                case OFF: 
                case NA: {
                    this.collect(cart, inv);
                    return;
                }
            }
        }
    }

    private void collect(Minecart cart, Inventory inv) {
        cart.eject();
        cart.setDamage(9000);
        cart.remove();
        if (inv != null) {
            int cartType = ItemType.MINECART.getID();
            if (cart instanceof StorageMinecart) {
                cartType = ItemType.STORAGE_MINECART.getID();
            } else if (cart instanceof PoweredMinecart) {
                cartType = ItemType.POWERED_MINECART.getID();
            }
            inv.addItem(new ItemStack[]{new ItemStack(cartType, 1)});
        }
    }

    private void dispense(CartMechanismBlocks blocks, Inventory inv, CartType type) {
        if (inv != null) {
            if (type.equals((Object)CartType.Minecart)) {
                if (!inv.contains(ItemType.MINECART.getID())) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(ItemType.MINECART.getID(), 1)});
            } else if (type.equals((Object)CartType.StorageMinecart)) {
                if (!inv.contains(ItemType.STORAGE_MINECART.getID())) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(ItemType.STORAGE_MINECART.getID(), 1)});
            } else if (type.equals((Object)CartType.PoweredMinecart)) {
                if (!inv.contains(ItemType.POWERED_MINECART.getID())) {
                    return;
                }
                inv.removeItem(new ItemStack[]{new ItemStack(ItemType.POWERED_MINECART.getID(), 1)});
            }
        }
        blocks.rail.getWorld().spawn(BukkitUtil.center((Location)blocks.rail.getLocation()), type.toClass());
    }

    public void enter(Minecart cart, Entity entity, CartMechanismBlocks blocks, boolean minor) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CartType {
        Minecart("Minecart", Minecart.class),
        StorageMinecart("Storage", StorageMinecart.class),
        PoweredMinecart("Powered", PoweredMinecart.class);

        private final Class<?> cl;
        private final String name;

        private CartType(String name, Class<?> cl) {
            this.name = name;
            this.cl = cl;
        }

        public static CartType fromString(String s) {
            for (CartType ct : CartType.values()) {
                if (ct == null || !ct.name.equalsIgnoreCase(s)) continue;
                return ct;
            }
            return Minecart;
        }

        public Class toClass() {
            return this.cl;
        }
    }
}

