/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.util.Vector;

public class CartTeleporter
extends CartMechanism {
    public void impact(Minecart cart, CartMechanismBlocks blocks, boolean minor) {
        if (cart == null) {
            return;
        }
        if (blocks.sign == null) {
            return;
        }
        if (!blocks.matches("teleport")) {
            return;
        }
        World world = cart.getWorld();
        String line = blocks.getSign().getLine(2);
        String[] pts = line.split(",");
        if (pts.length != 3) {
            return;
        }
        if (!blocks.getSign().getLine(3).equals("")) {
            world = cart.getServer().getWorld(blocks.getSign().getLine(3));
        }
        Double x = 0.0;
        Double y = 0.0;
        Double z = 0.0;
        try {
            x = Double.parseDouble(pts[0]);
            y = Double.parseDouble(pts[1]);
            z = Double.parseDouble(pts[2]);
        }
        catch (NumberFormatException e) {
            if (blocks.from != null) {
                x = blocks.from.getLocation().getX();
                y = blocks.from.getLocation().getY();
                z = blocks.from.getLocation().getZ();
            } else {
                x = blocks.rail.getX();
                y = blocks.rail.getY();
                z = blocks.rail.getZ();
            }
            cart.setVelocity(new Vector(0.0, 0.0, 0.0));
        }
        Location loc = BukkitUtil.center((Location)new Location(world, x, y, z, 0.0f, 0.0f){});
        if (!loc.getChunk().isLoaded()) {
            loc.getChunk().load(true);
        }
        if (cart.getWorld() == world) {
            cart.teleport(loc);
        } else {
            Minecart toCart = (Minecart)world.spawn(loc, Minecart.class);
            Entity passenger = cart.getPassenger();
            if (passenger != null) {
                cart.eject();
                passenger.teleport(loc);
                toCart.setPassenger(passenger);
            }
            toCart.setVelocity(cart.getVelocity());
            cart.remove();
        }
    }

    public void enter(Minecart cart, Entity entity, CartMechanismBlocks blocks, boolean minor) {
    }
}

