/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.cart;

import com.sk89q.craftbook.InvalidMechanismException;
import com.sk89q.craftbook.VehiclesConfiguration;
import com.sk89q.craftbook.bukkit.VehiclesPlugin;
import com.sk89q.craftbook.cart.CartBooster;
import com.sk89q.craftbook.cart.CartDeposit;
import com.sk89q.craftbook.cart.CartDispenser;
import com.sk89q.craftbook.cart.CartEjector;
import com.sk89q.craftbook.cart.CartMechanism;
import com.sk89q.craftbook.cart.CartMechanismBlocks;
import com.sk89q.craftbook.cart.CartMessager;
import com.sk89q.craftbook.cart.CartReverser;
import com.sk89q.craftbook.cart.CartSorter;
import com.sk89q.craftbook.cart.CartStation;
import com.sk89q.craftbook.cart.CartTeleporter;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Minecart;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.plugin.Plugin;

public class MinecartManager {
    private final VehiclesPlugin plugin;
    private Map<Material, CartMechanism> mechanisms;

    public MinecartManager(VehiclesPlugin plugin) {
        this.plugin = plugin;
        this.reloadConfiguration(plugin.getLocalConfiguration());
    }

    public void reloadConfiguration(VehiclesConfiguration cfg) {
        this.mechanisms = new EnumMap<Material, CartMechanism>(Material.class);
        this.mechanisms.put(cfg.matBoostMax, new CartBooster(100.0));
        this.mechanisms.put(cfg.matBoost25x, new CartBooster(1.25));
        this.mechanisms.put(cfg.matSlow20x, new CartBooster(0.8));
        this.mechanisms.put(cfg.matSlow50x, new CartBooster(0.5));
        this.mechanisms.put(cfg.matReverse, new CartReverser());
        this.mechanisms.put(cfg.matSorter, new CartSorter());
        this.mechanisms.put(cfg.matStation, new CartStation());
        this.mechanisms.put(cfg.matEjector, new CartEjector());
        this.mechanisms.put(cfg.matDeposit, new CartDeposit());
        this.mechanisms.put(cfg.matTeleport, new CartTeleporter());
        this.mechanisms.put(cfg.matDispenser, new CartDispenser());
        this.mechanisms.put(cfg.matMessager, new CartMessager(this.plugin));
        for (Map.Entry<Material, CartMechanism> ent : this.mechanisms.entrySet()) {
            ent.getValue().setMaterial(ent.getKey());
        }
    }

    public void impact(VehicleMoveEvent event) {
        try {
            CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(event.getTo().getBlock());
            cmb.setFromBlock(event.getFrom().getBlock());
            CartMechanism thingy = this.mechanisms.get(cmb.base.getType());
            if (thingy != null) {
                Location from = event.getFrom();
                Location to = event.getTo();
                boolean crossesBlockBoundary = from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
                thingy.impact((Minecart)event.getVehicle(), cmb, crossesBlockBoundary);
            }
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
    }

    public void enter(VehicleEnterEvent event) {
        try {
            CartMechanismBlocks cmb = CartMechanismBlocks.findByRail(event.getVehicle().getLocation().getBlock());
            cmb.setFromBlock(event.getVehicle().getLocation().getBlock());
            CartMechanism thingy = this.mechanisms.get(cmb.base.getType());
            if (thingy != null) {
                Location to = event.getVehicle().getLocation();
                Location from = event.getEntered().getLocation();
                boolean crossesBlockBoundary = from.getBlockX() == to.getBlockX() && from.getBlockY() == to.getBlockY() && from.getBlockZ() == to.getBlockZ();
                thingy.enter((Minecart)event.getVehicle(), event.getEntered(), cmb, crossesBlockBoundary);
            }
        }
        catch (InvalidMechanismException invalidMechanismException) {
            // empty catch block
        }
    }

    public void impact(BlockRedstoneEvent event) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new DelayedImpact(event));
    }

    private class DelayedImpact
    implements Runnable {
        private final Block huh;

        public DelayedImpact(BlockRedstoneEvent event) {
            this.huh = event.getBlock();
        }

        public void run() {
            try {
                CartMechanismBlocks cmb = CartMechanismBlocks.find(this.huh);
                CartMechanism thingy = (CartMechanism)MinecartManager.this.mechanisms.get(cmb.base.getType());
                if (thingy != null) {
                    thingy.impact(CartMechanism.getCart(cmb.rail), cmb, false);
                }
            }
            catch (InvalidMechanismException invalidMechanismException) {
                // empty catch block
            }
        }
    }
}

