/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.circuits;

import com.sk89q.craftbook.AbstractMechanic;
import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.world.ChunkUnloadEvent;

public class Netherrack
extends AbstractMechanic {
    private Netherrack(BlockWorldVector pt) {
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        Block above = event.getBlock().getRelative(0, 1, 0);
        if (event.getNewCurrent() > 0 && above != null && above.getTypeId() == 0) {
            above.setTypeId(51);
        } else if (above.getTypeId() == 51) {
            above.setTypeId(0);
        }
    }

    public void onLeftClick(PlayerInteractEvent event) {
        if (event.getBlockFace() != BlockFace.UP) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block.isBlockIndirectlyPowered()) {
            event.setCancelled(true);
            return;
        }
        if ((block = block.getRelative(0, -1, 0)).isBlockIndirectlyPowered()) {
            event.setCancelled(true);
        }
    }

    public void unload() {
    }

    public boolean isActive() {
        return false;
    }

    public void onBlockBreak(BlockBreakEvent event) {
    }

    public void unloadWithEvent(ChunkUnloadEvent event) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<Netherrack> {
        public Netherrack detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == 87) {
                return new Netherrack(pt);
            }
            return null;
        }
    }
}

