/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class Clock
extends AbstractIC
implements SelfTriggeredIC {
    final Sign sign;

    public Clock(Server server, Sign psign) {
        super(server, psign);
        this.sign = psign;
    }

    public String getTitle() {
        return "Clock";
    }

    public String getSignTitle() {
        return "CLOCK";
    }

    public void trigger(ChipState chip) {
    }

    public void think(ChipState chip) {
        short tick;
        short reset;
        try {
            reset = Short.parseShort(this.sign.getLine(2));
        }
        catch (NumberFormatException e) {
            return;
        }
        try {
            tick = Short.parseShort(this.sign.getLine(3));
        }
        catch (NumberFormatException e) {
            tick = 0;
        }
        tick = (short)(tick + 1);
        if (tick == reset) {
            tick = 0;
            chip.setOutput(0, !chip.getOutput(0));
        }
        this.sign.setLine(3, Short.toString(tick));
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new Clock(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            int lol;
            try {
                lol = Integer.parseInt(sign.getLine(2));
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a number between 5 and 150.");
            }
            lol = Math.max(lol, 5);
            lol = Math.min(lol, 150);
            sign.setLine(2, Integer.toString(lol));
            sign.setLine(3, "0");
            sign.update();
        }
    }
}

