/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class Counter
extends AbstractIC {
    private int resetVal;
    private boolean inf;

    public Counter(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        String line2 = this.getSign().getLine(2);
        String[] config = line2.split(":");
        this.resetVal = 0;
        this.inf = false;
        try {
            this.resetVal = Integer.parseInt(config[0]);
            this.inf = config[1].equals("INF");
        }
        catch (NumberFormatException e) {
            this.resetVal = 5;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.inf = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getSign().setLine(2, this.resetVal + (this.inf ? ":INF" : ""));
        this.getSign().update();
    }

    public String getTitle() {
        return "Counter";
    }

    public String getSignTitle() {
        return "COUNTER";
    }

    public void trigger(ChipState chip) {
        int curVal;
        String line3 = this.getSign().getLine(3);
        try {
            curVal = Integer.parseInt(line3);
        }
        catch (Exception e) {
            curVal = 0;
        }
        int oldVal = curVal;
        try {
            if (chip.isTriggered(0) && chip.get(0)) {
                if (curVal == this.resetVal) {
                    if (this.inf) {
                        curVal = 0;
                    }
                } else {
                    ++curVal;
                }
                chip.setOutput(0, curVal == this.resetVal);
            } else if (chip.isTriggered(1) && chip.get(1)) {
                curVal = 0;
                chip.setOutput(0, false);
            }
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (curVal != oldVal) {
            this.getSign().setLine(3, curVal + "");
            this.getSign().update();
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new Counter(this.getServer(), sign);
        }
    }
}

