/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class MemoryAccess
extends AbstractIC {
    public MemoryAccess(Server server, Sign block) {
        super(server, block);
    }

    public String getTitle() {
        return "ROM Accessor";
    }

    public String getSignTitle() {
        return "ROM";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.readMemory(chip);
        }
    }

    public boolean readMemory(ChipState chip) {
        try {
            String line;
            File f = new File("plugins/CraftBookCircuits/ROM/", this.getSign().getLine(2));
            if (!f.exists()) {
                f.createNewFile();
                return false;
            }
            BufferedReader br = new BufferedReader(new FileReader(f));
            for (int linenum = 0; (line = br.readLine()) != null || linenum > 2; ++linenum) {
                chip.setOutput(linenum, line.equalsIgnoreCase("1"));
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new MemoryAccess(this.getServer(), sign);
        }
    }
}

