/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.weather;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class WeatherControl
extends AbstractIC {
    public WeatherControl(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Weather Control";
    }

    public String getSignTitle() {
        return "WEATHER CONTROL";
    }

    public void trigger(ChipState chip) {
        int duration;
        boolean tstorm = false;
        int thunderDuration = duration = 24000;
        try {
            String[] st = this.getSign().getLine(1).split("]");
            if (st.length > 1) {
                tstorm = st[1].equalsIgnoreCase("t");
            }
            duration = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            thunderDuration = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (duration > 24000) {
            duration = 24000;
        }
        if (duration < 1) {
            duration = 1;
        }
        if (thunderDuration > 24000) {
            thunderDuration = 24000;
        }
        if (thunderDuration < 1) {
            thunderDuration = 1;
        }
        if (chip.getInput(0)) {
            this.getSign().getWorld().setStorm(true);
            this.getSign().getWorld().setWeatherDuration(duration);
            if (tstorm) {
                this.getSign().getWorld().setThundering(true);
                this.getSign().getWorld().setThunderDuration(thunderDuration);
            }
            chip.setOutput(0, true);
        } else {
            this.getSign().getWorld().setThundering(false);
            this.getSign().getWorld().setStorm(false);
            chip.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new WeatherControl(this.getServer(), sign);
        }
    }
}

