/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.weather;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class WeatherControlAdvanced
extends AbstractIC {
    public WeatherControlAdvanced(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Weather Control";
    }

    public String getSignTitle() {
        return "WEATHER CONTROL";
    }

    public void trigger(ChipState chip) {
        int duration;
        int thunderDuration = duration = 24000;
        try {
            duration = Integer.parseInt(this.getSign().getLine(2));
            thunderDuration = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (Exception ignored) {
            // empty catch block
        }
        if (duration > 24000) {
            duration = 24000;
        } else if (duration < 1) {
            duration = 1;
        }
        if (thunderDuration > 24000) {
            thunderDuration = 24000;
        } else if (thunderDuration < 1) {
            thunderDuration = 1;
        }
        if (chip.isTriggered(0) && chip.getInput(0)) {
            this.getSign().getWorld().setStorm(chip.getInput(1));
            if (chip.getInput(1)) {
                this.getSign().getWorld().setWeatherDuration(duration);
            }
            this.getSign().getWorld().setThundering(chip.getInput(2));
            if (chip.getInput(2)) {
                this.getSign().getWorld().setThunderDuration(thunderDuration);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new WeatherControlAdvanced(this.getServer(), sign);
        }
    }
}

