/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.util.Vector;

public class ArrowShooter
extends AbstractIC {
    public ArrowShooter(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Arrow Shooter";
    }

    public String getSignTitle() {
        return "ARROW SHOOTER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootArrows(1);
        }
    }

    public void shootArrows(int n) {
        float speed = 0.6f;
        float spread = 12.0f;
        float vert = 0.0f;
        try {
            String[] velocity = this.getSign().getLine(2).trim().split(":");
            speed = Float.parseFloat(velocity[0]);
            spread = Float.parseFloat(velocity[1]);
            vert = Float.parseFloat(this.getSign().getLine(3).trim());
        }
        catch (Exception e) {
            this.getSign().setLine(2, speed + ":" + spread + ":" + vert);
            this.getSign().update();
        }
        if ((double)speed > 2.0) {
            speed = 2.0f;
        } else if ((double)speed < 0.2) {
            speed = 0.2f;
        }
        if (spread > 50.0f) {
            spread = 50.0f;
        } else if (spread < 0.0f) {
            spread = 0.0f;
        }
        if (vert > 1.0f) {
            vert = 1.0f;
        } else if (vert < -1.0f) {
            vert = -1.0f;
        }
        Block signBlock = this.getSign().getBlock();
        BlockFace face = SignUtil.getBack((Block)signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        float x = targetDir.getX() - signBlock.getX();
        float z = targetDir.getZ() - signBlock.getZ();
        Vector velocity = new Vector(x, vert, z);
        Location shootLoc = new Location(this.getSign().getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        for (int i = 0; i < n; i = (int)((short)(i + 1))) {
            this.getSign().getWorld().spawnArrow(shootLoc, velocity, speed, spread);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new ArrowShooter(this.getServer(), sign);
        }
    }
}

