/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class BlockSensor
extends AbstractIC {
    private Block center;
    private int id = 0;
    private byte data = (byte)-1;

    public BlockSensor(Server server, Sign sign) {
        super(server, sign);
        this.load();
    }

    private void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
        String ids = this.getSign().getLine(3);
        try {
            this.id = Integer.parseInt(ids.split(":")[0]);
            this.data = Byte.parseByte(ids.split(":")[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Block Sensor";
    }

    public String getSignTitle() {
        return "BLOCK SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasBlock());
        }
    }

    protected boolean hasBlock() {
        int blockID = this.center.getTypeId();
        if (this.data != -1 && blockID == this.id) {
            return this.data == this.center.getData();
        }
        return blockID == this.id;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new BlockSensor(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            try {
                String[] split = sign.getLine(3).split(":");
                Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                throw new ICVerificationException("You need to specify an block in line four.");
            }
            ICUtil.verifySignSyntax(sign);
        }
    }
}

