/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.BlockSensor;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class BlockSensorST
extends BlockSensor
implements SelfTriggeredIC {
    public BlockSensorST(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Self-triggered Block Sensor";
    }

    public String getSignTitle() {
        return "ST BLOCK SENSOR";
    }

    public void think(ChipState chip) {
        chip.setOutput(0, this.hasBlock());
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new BlockSensorST(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            try {
                String[] split = sign.getLine(3).split(":");
                Integer.parseInt(split[0]);
            }
            catch (Exception ignored) {
                throw new ICVerificationException("You need to specify an block in line four.");
            }
            ICUtil.verifySignSyntax(sign);
        }
    }
}

