/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ChestCollector
extends AbstractIC {
    public ChestCollector(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Chest Collector";
    }

    public String getSignTitle() {
        return "CHEST COLLECT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.collect());
        }
    }

    protected boolean collect() {
        Block b = SignUtil.getBackBlock((Block)this.getSign().getBlock());
        int x = b.getX();
        int y = b.getY() + 1;
        int z = b.getZ();
        Block bl = this.getSign().getBlock().getWorld().getBlockAt(x, y, z);
        if (bl.getType() == Material.CHEST) {
            World w = this.getSign().getBlock().getWorld();
            for (Item item : w.getEntitiesByClass(Item.class)) {
                int ix = item.getLocation().getBlockX();
                int iy = item.getLocation().getBlockY();
                int iz = item.getLocation().getBlockZ();
                if (ix != this.getSign().getX() || iy != this.getSign().getY() || iz != this.getSign().getZ() || ((Chest)bl.getState()).getInventory().firstEmpty() == -1) continue;
                int id = -1;
                int idmeta = -1;
                int exid = -1;
                int exidmeta = -1;
                try {
                    if (this.getSign().getLine(2).contains(":")) {
                        id = Integer.parseInt(this.getSign().getLine(2).split(":")[0]);
                        idmeta = Integer.parseInt(this.getSign().getLine(2).split(":")[1]);
                    } else {
                        id = Integer.parseInt(this.getSign().getLine(2));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                try {
                    if (this.getSign().getLine(3).contains(":")) {
                        exid = Integer.parseInt(this.getSign().getLine(3).split(":")[0]);
                        exidmeta = Integer.parseInt(this.getSign().getLine(3).split(":")[1]);
                    } else {
                        exid = Integer.parseInt(this.getSign().getLine(3));
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (exid == -1 ? id != -1 && (id != item.getItemStack().getTypeId() || idmeta != -1 && item.getItemStack().getDurability() != idmeta) : exid == item.getItemStack().getTypeId() && (exidmeta == -1 || item.getItemStack().getDurability() == exidmeta)) continue;
                ((Chest)bl.getState()).getInventory().addItem(new ItemStack[]{item.getItemStack()});
                item.remove();
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new ChestCollector(this.getServer(), sign);
        }
    }
}

