/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.util.ItemUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;

public class ChestDispenser
extends AbstractIC {
    private int amount = 1;

    public ChestDispenser(Server server, Sign sign) {
        super(server, sign);
        try {
            this.amount = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception ignored) {
            sign.setLine(2, this.amount + "");
            sign.update();
        }
    }

    public String getTitle() {
        return "Chest Dispenser";
    }

    public String getSignTitle() {
        return "CHEST DISPENSER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.dispense());
        }
    }

    protected boolean dispense() {
        Block b = SignUtil.getBackBlock((Block)this.getSign().getBlock());
        int x = b.getX();
        int y = b.getY() + 1;
        int z = b.getZ();
        Block bl = this.getSign().getBlock().getWorld().getBlockAt(x, y, z);
        if (bl.getType() == Material.CHEST) {
            ItemStack[] is;
            Chest c = (Chest)bl.getState();
            for (ItemStack i1 : is = c.getInventory().getContents()) {
                if (!ItemUtil.isStackValid((ItemStack)i1)) continue;
                int curA = i1.getAmount();
                ItemStack stack = new ItemStack(i1.getTypeId(), i1.getAmount(), (short)i1.getData().getData());
                stack.setAmount(1);
                this.getSign().getWorld().dropItemNaturally(new Location(this.getSign().getWorld(), (double)this.getSign().getX(), (double)this.getSign().getY(), (double)this.getSign().getZ()), stack);
                i1.setAmount(curA - this.amount);
                break;
            }
            c.getInventory().setContents(is);
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new ChestDispenser(this.getServer(), sign);
        }
    }
}

