/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.MagmaCube;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;

public class CreatureSpawner
extends AbstractIC {
    private EntityType entityType = EntityType.PIG;
    private String data;
    private int amount = 1;
    private Block center;

    public CreatureSpawner(Server server, Sign sign) {
        super(server, sign);
        this.load();
    }

    private void load() {
        this.entityType = EntityType.fromName((String)this.getSign().getLine(2).trim());
        String line = this.getSign().getLine(3).trim();
        try {
            String[] entityInf = line.split(":");
            this.data = entityInf[0];
            this.amount = Integer.parseInt(entityInf[1]);
        }
        catch (Exception e) {
            this.data = line;
        }
        this.center = SignUtil.getBackBlock((Block)this.getSign().getBlock());
    }

    public String getTitle() {
        return "Creature Spawner";
    }

    public String getSignTitle() {
        return "CREATURE SPAWNER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0) && this.entityType != null && this.entityType.isAlive()) {
            Location center = LocationUtil.getCenterOfBlock((Block)LocationUtil.getNextFreeSpace((Block)this.center, (BlockFace)BlockFace.UP));
            if (!this.data.equals("")) {
                Entity entity = center.getWorld().spawnEntity(center, this.entityType);
                this.setEntityData(entity, this.data);
            } else {
                for (int i = 0; i < this.amount; ++i) {
                    Entity entity = center.getWorld().spawnEntity(center, this.entityType);
                    this.setEntityData(entity, this.data);
                }
            }
        }
    }

    public void setEntityData(Entity ent, String data) {
        switch (ent.getType()) {
            case CREEPER: {
                if (!data.equalsIgnoreCase("charged")) break;
                ((Creeper)ent).setPowered(true);
                break;
            }
            case SLIME: {
                if (data.equalsIgnoreCase("huge")) {
                    ((Slime)ent).setSize(16);
                    break;
                }
                if (data.equalsIgnoreCase("large")) {
                    ((Slime)ent).setSize(11);
                    break;
                }
                if (data.equalsIgnoreCase("normal")) {
                    ((Slime)ent).setSize(6);
                    break;
                }
                if (!data.equalsIgnoreCase("small")) break;
                ((Slime)ent).setSize(3);
                break;
            }
            case MAGMA_CUBE: {
                if (data.equalsIgnoreCase("huge")) {
                    ((MagmaCube)ent).setSize(16);
                    break;
                }
                if (data.equalsIgnoreCase("large")) {
                    ((MagmaCube)ent).setSize(11);
                    break;
                }
                if (data.equalsIgnoreCase("normal")) {
                    ((MagmaCube)ent).setSize(6);
                    break;
                }
                if (!data.equalsIgnoreCase("small")) break;
                ((MagmaCube)ent).setSize(3);
                break;
            }
            case WOLF: {
                if (data.equalsIgnoreCase("tame")) {
                    ((Wolf)ent).setTamed(true);
                    break;
                }
                if (!data.equalsIgnoreCase("angry")) break;
                ((Wolf)ent).setAngry(true);
                break;
            }
            case PIG_ZOMBIE: {
                if (!data.equalsIgnoreCase("angry")) break;
                ((PigZombie)ent).setAngry(true);
                break;
            }
            case VILLAGER: {
                if (data.equalsIgnoreCase("butcher")) {
                    ((Villager)ent).setProfession(Villager.Profession.BUTCHER);
                    break;
                }
                if (data.equalsIgnoreCase("smith")) {
                    ((Villager)ent).setProfession(Villager.Profession.BLACKSMITH);
                    break;
                }
                if (data.equalsIgnoreCase("priest")) {
                    ((Villager)ent).setProfession(Villager.Profession.PRIEST);
                    break;
                }
                if (data.equalsIgnoreCase("library")) {
                    ((Villager)ent).setProfession(Villager.Profession.LIBRARIAN);
                    break;
                }
                if (!data.equalsIgnoreCase("farmer")) break;
                ((Villager)ent).setProfession(Villager.Profession.FARMER);
                break;
            }
            case SHEEP: {
                if (data.equalsIgnoreCase("black")) {
                    ((Sheep)ent).setColor(DyeColor.BLACK);
                    break;
                }
                if (data.equalsIgnoreCase("red")) {
                    ((Sheep)ent).setColor(DyeColor.RED);
                    break;
                }
                if (data.equalsIgnoreCase("green")) {
                    ((Sheep)ent).setColor(DyeColor.GREEN);
                    break;
                }
                if (data.equalsIgnoreCase("brown")) {
                    ((Sheep)ent).setColor(DyeColor.BROWN);
                    break;
                }
                if (data.equalsIgnoreCase("blue")) {
                    ((Sheep)ent).setColor(DyeColor.BLUE);
                    break;
                }
                if (data.equalsIgnoreCase("purple")) {
                    ((Sheep)ent).setColor(DyeColor.PURPLE);
                    break;
                }
                if (data.equalsIgnoreCase("cyan")) {
                    ((Sheep)ent).setColor(DyeColor.CYAN);
                    break;
                }
                if (data.equalsIgnoreCase("silver")) {
                    ((Sheep)ent).setColor(DyeColor.SILVER);
                    break;
                }
                if (data.equalsIgnoreCase("gray")) {
                    ((Sheep)ent).setColor(DyeColor.GRAY);
                    break;
                }
                if (data.equalsIgnoreCase("pink")) {
                    ((Sheep)ent).setColor(DyeColor.PINK);
                    break;
                }
                if (data.equalsIgnoreCase("lime")) {
                    ((Sheep)ent).setColor(DyeColor.LIME);
                    break;
                }
                if (data.equalsIgnoreCase("yellow")) {
                    ((Sheep)ent).setColor(DyeColor.YELLOW);
                    break;
                }
                if (data.equalsIgnoreCase("lblue")) {
                    ((Sheep)ent).setColor(DyeColor.LIGHT_BLUE);
                    break;
                }
                if (data.equalsIgnoreCase("magenta")) {
                    ((Sheep)ent).setColor(DyeColor.MAGENTA);
                    break;
                }
                if (data.equalsIgnoreCase("orange")) {
                    ((Sheep)ent).setColor(DyeColor.ORANGE);
                    break;
                }
                if (!data.equalsIgnoreCase("white")) break;
                ((Sheep)ent).setColor(DyeColor.WHITE);
                break;
            }
            default: {
                if (!(ent instanceof Animals) || !data.equalsIgnoreCase("baby")) break;
                ((Animals)ent).setBaby();
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new CreatureSpawner(this.getServer(), sign);
        }
    }
}

