/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;

public class EntitySensor
extends AbstractIC {
    private HashSet<Type> types;
    private Block center;
    private Set<Chunk> chunks;
    private int radius;

    public EntitySensor(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        Sign sign = this.getSign();
        this.types = Type.getDetected(sign.getLine(3).trim());
        if (this.types.size() == 0) {
            this.types.add(Type.ANY);
        }
        sign.setLine(3, sign.getLine(3).toUpperCase());
        sign.update();
        this.radius = ICUtil.parseRadius(this.getSign());
        this.center = this.getSign().getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()) : SignUtil.getBackBlock((Block)this.getSign().getBlock());
        this.chunks = LocationUtil.getSurroundingChunks((Block)SignUtil.getBackBlock((Block)sign.getBlock()), (int)this.radius);
    }

    public String getTitle() {
        return "Entity Sensor";
    }

    public String getSignTitle() {
        return "ENTITY SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    protected boolean isDetected() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            block1: for (Entity entity : chunk.getEntities()) {
                if (entity.isDead() || !entity.isValid()) continue;
                for (Type type : this.types) {
                    if (!type.is(entity)) continue;
                    if (!LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue block1;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new EntitySensor(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER('P'),
        ITEM('I'),
        MOB_HOSTILE('H'),
        MOB_PEACEFUL('A'),
        MOB_ANY('M'),
        ANY('L'),
        CART('C'),
        CART_STORAGE('S'),
        CART_POWERED('E');

        private final char shortName;

        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case ITEM: {
                    return entity instanceof Item;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster;
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
                case CART: {
                    return entity instanceof Minecart;
                }
                case CART_STORAGE: {
                    return entity instanceof StorageMinecart;
                }
                case CART_POWERED: {
                    return entity instanceof PoweredMinecart;
                }
                case ANY: {
                    return true;
                }
            }
            return false;
        }

        private Type(char shortName) {
            this.shortName = shortName;
        }

        public char getCharName() {
            return this.shortName;
        }

        public static HashSet<Type> getDetected(String line) {
            HashSet<Type> types = new HashSet<Type>();
            Type type = (Type)EnumUtil.getEnumFromString(Type.class, (String)line);
            if (type != null) {
                types.add(type);
            } else {
                for (char aChar : line.toCharArray()) {
                    for (Type aType : Type.values()) {
                        if (aType.getCharName() != aChar) continue;
                        types.add(aType);
                    }
                }
            }
            if (types.size() == 0) {
                types.add(ANY);
            }
            return types;
        }
    }
}

