/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.LocationUtil;
import java.util.Collection;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.PoweredMinecart;
import org.bukkit.entity.StorageMinecart;

public class EntityTrap
extends AbstractIC {
    private Block center;
    private int radius;
    private Type type;
    private Collection<Chunk> chunks;

    public EntityTrap(Server server, Sign sign) {
        super(server, sign);
        this.load();
    }

    private void load() {
        Sign sign = this.getSign();
        this.center = ICUtil.parseBlockLocation(sign);
        this.radius = ICUtil.parseRadius(sign);
        this.type = Type.fromString(sign.getLine(3).trim());
        if (this.type == null) {
            this.type = Type.ANY;
        }
        sign.setLine(3, this.type.name());
        sign.update();
        this.chunks = LocationUtil.getSurroundingChunks((Block)this.center, (int)this.radius);
    }

    public String getTitle() {
        return "Entity Trap";
    }

    public String getSignTitle() {
        return "ENTITY TRAP";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hurt());
        }
    }

    protected boolean hurt() {
        int damage = 2;
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            for (Entity entity : chunk.getEntities()) {
                if (entity.isDead() || !this.type.is(entity) || !LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue;
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).damage(damage);
                } else if (entity instanceof Minecart) {
                    ((Minecart)entity).setDamage(((Minecart)entity).getDamage() + damage);
                } else {
                    entity.remove();
                }
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new EntityTrap(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER,
        MOB_HOSTILE,
        MOB_PEACEFUL,
        MOB_ANY,
        ANY,
        CART,
        CART_STORAGE,
        CART_POWERED;


        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster;
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
                case CART: {
                    return entity instanceof Minecart;
                }
                case CART_STORAGE: {
                    return entity instanceof StorageMinecart;
                }
                case CART_POWERED: {
                    return entity instanceof PoweredMinecart;
                }
                case ANY: {
                    return true;
                }
            }
            return false;
        }

        public static Type fromString(String name) {
            return (Type)EnumUtil.getEnumFromString(Type.class, (String)name);
        }
    }
}

