/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.SmallFireball;
import org.bukkit.util.Vector;

public class FireShooter
extends AbstractIC {
    private float speed = 0.6f;
    private float spread = 4.0f;
    private float vert = 0.0f;

    public FireShooter(Server server, Sign sign) {
        super(server, sign);
        this.load();
    }

    private void load() {
        try {
            String[] velocity = this.getSign().getLine(2).trim().split(":");
            this.speed = Float.parseFloat(velocity[0]);
            this.spread = Float.parseFloat(velocity[1]);
            this.vert = Float.parseFloat(this.getSign().getLine(3).trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTitle() {
        return "Fire Shooter";
    }

    public String getSignTitle() {
        return "FIRE SHOOTER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.shootFire(1);
        }
    }

    public void shootFire(int n) {
        if ((double)this.speed > 2.0) {
            this.speed = 2.0f;
        } else if ((double)this.speed < 0.2) {
            this.speed = 0.2f;
        }
        if (this.spread > 50.0f) {
            this.spread = 50.0f;
        } else if (this.spread < 0.0f) {
            this.spread = 0.0f;
        }
        if (this.vert > 1.0f) {
            this.vert = 1.0f;
        } else if (this.vert < -1.0f) {
            this.vert = -1.0f;
        }
        Block signBlock = this.getSign().getBlock();
        BlockFace face = SignUtil.getBack((Block)signBlock);
        Block targetDir = signBlock.getRelative(face).getRelative(face);
        float x = targetDir.getX() - signBlock.getX();
        float z = targetDir.getZ() - signBlock.getZ();
        Vector velocity = new Vector(x, this.vert, z);
        Location shootLoc = new Location(this.getSign().getWorld(), (double)targetDir.getX() + 0.5, (double)targetDir.getY() + 0.5, (double)targetDir.getZ() + 0.5);
        if (n != 1) {
            for (int i = 0; i < n; i = (int)((short)(i + 1))) {
                Random rand = new Random();
                velocity = new Vector(x + ((float)rand.nextInt((int)this.spread) - this.spread / 2.0f), this.vert + ((float)rand.nextInt((int)this.spread) - this.spread / 2.0f), z + ((float)rand.nextInt((int)this.spread) - this.spread / 2.0f));
                SmallFireball f = (SmallFireball)this.getSign().getWorld().spawn(shootLoc, SmallFireball.class);
                f.setVelocity(velocity);
            }
        } else {
            SmallFireball f = (SmallFireball)this.getSign().getWorld().spawn(shootLoc, SmallFireball.class);
            f.setVelocity(velocity);
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new FireShooter(this.getServer(), sign);
        }
    }
}

