/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.worldedit.blocks.BlockType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;

public class ItemDispenser
extends AbstractIC {
    public ItemDispenser(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Item Dispenser";
    }

    public String getSignTitle() {
        return "ITEM DISPENSER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Material mat;
            String item = this.getSign().getLine(2);
            int amount = 1;
            try {
                amount = Math.min(64, Math.max(-1, Integer.parseInt(this.getSign().getLine(3))));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            byte data = 0;
            if (item.contains(":")) {
                data = Byte.parseByte(item.split(":")[1]);
                item = item.split(":")[0];
            }
            if ((mat = Material.matchMaterial((String)item)) == null) {
                return;
            }
            int id = mat.getId();
            if (id != 0 && id != 36 && (id < 26 || id > 34)) {
                Location loc = this.getSign().getBlock().getLocation();
                int maxY = Math.min(this.getSign().getWorld().getMaxHeight(), loc.getBlockY() + 10);
                int x = loc.getBlockX();
                int z = loc.getBlockZ();
                for (int y = loc.getBlockY() + 1; y <= maxY; ++y) {
                    if (!BlockType.canPassThrough((int)this.getSign().getWorld().getBlockTypeIdAt(x, y, z))) continue;
                    ItemStack stack = new ItemStack(id, amount, (short)data);
                    stack.setData(new MaterialData(id, data));
                    this.getSign().getWorld().dropItemNaturally(new Location(this.getSign().getWorld(), (double)x, (double)y, (double)z), stack);
                    return;
                }
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new ItemDispenser(this.getServer(), sign);
        }
    }
}

