/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.inventory.ItemStack;

public class ItemSensor
extends AbstractIC {
    private int item = 0;
    private short data = (short)-1;
    private Block center;
    private Set<Chunk> chunks;
    private int radius;

    public ItemSensor(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        String[] split;
        Block block;
        block4: {
            Sign sign = this.getSign();
            block = SignUtil.getBackBlock((Block)sign.getBlock());
            split = sign.getLine(3).trim().split(":");
            try {
                this.item = Integer.parseInt(split[0]);
            }
            catch (NumberFormatException e) {
                Material material = Material.getMaterial((String)split[0]);
                if (material == null) break block4;
                this.item = material.getId();
            }
        }
        if (this.item == 0) {
            this.item = 1;
        }
        if (split.length > 1) {
            this.data = Short.parseShort(split[1]);
        }
        this.radius = ICUtil.parseRadius(this.getSign());
        this.center = this.getSign().getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()) : SignUtil.getBackBlock((Block)this.getSign().getBlock());
        this.chunks = LocationUtil.getSurroundingChunks((Block)block, (int)this.radius);
    }

    public String getTitle() {
        return "Item Detection";
    }

    public String getSignTitle() {
        return "ITEM DETECTION";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    protected boolean isDetected() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            for (Entity entity : chunk.getEntities()) {
                ItemStack itemStack;
                if (!(entity instanceof Item) || (itemStack = ((Item)entity).getItemStack()).getTypeId() != this.item) continue;
                if (this.data != -1 && itemStack.getDurability() != this.data) {
                    return false;
                }
                if (!LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue;
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new ItemSensor(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

