/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class LightSensor
extends AbstractIC {
    public LightSensor(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Light Sensor";
    }

    public String getSignTitle() {
        return "LIGHT SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.getTargetLighted());
        }
    }

    protected boolean getTargetLighted() {
        int x = 0;
        int y = 1;
        int z = 0;
        int min = 10;
        try {
            String[] st = this.getSign().getLine(3).split(":");
            if (st.length != 3) {
                throw new Exception();
            }
            x = Integer.parseInt(st[0]);
            y = Integer.parseInt(st[1]);
            z = Integer.parseInt(st[2]);
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            min = Integer.parseInt(this.getSign().getLine(2));
        }
        catch (Exception e) {
            this.getSign().setLine(2, Integer.toString(min));
            this.getSign().update();
        }
        return this.hasLight(min, x, y, z);
    }

    private boolean hasLight(int specifiedLevel, int x, int y, int z) {
        Block signBlock = this.getSign().getBlock();
        Block backBlock = signBlock.getRelative(SignUtil.getBack((Block)signBlock));
        byte lightLevel = this.getSign().getWorld().getBlockAt(backBlock.getX() + x, backBlock.getY() + y, backBlock.getZ() + z).getLightLevel();
        return lightLevel >= specifiedLevel;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new LightSensor(this.getServer(), sign);
        }
    }
}

