/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class LightningSummon
extends AbstractIC {
    private Block center;

    public LightningSummon(Server server, Sign sign) {
        super(server, sign);
        this.load();
    }

    private void load() {
        String line = this.getSign().getLine(2);
        if (line.length() > 0) {
            this.center = SignUtil.getBackBlock((Block)this.getSign().getBlock().getRelative(BlockFace.UP, Integer.parseInt(line)));
        }
    }

    public String getTitle() {
        return "Zeus Bolt";
    }

    public String getSignTitle() {
        return "ZEUS BOLT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            Block target = this.center;
            if (target == null) {
                target = LocationUtil.getNextFreeSpace((Block)SignUtil.getBackBlock((Block)this.getSign().getBlock()), (BlockFace)BlockFace.UP);
            }
            target.getWorld().strikeLightning(target.getLocation());
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new LightningSummon(this.getServer(), sign);
        }
    }
}

