/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.gates.world.PowerSensor;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.jinglenote.JingleNoteComponent;
import com.sk89q.jinglenote.MidiJingleSequencer;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class Melody
extends AbstractIC {
    MidiJingleSequencer sequencer;
    JingleNoteComponent jNote = new JingleNoteComponent();

    public Melody(Server server, Sign block) {
        super(server, block);
    }

    public String getTitle() {
        return "Melody Player";
    }

    public String getSignTitle() {
        return "MELODY";
    }

    public void unload() {
        try {
            if (this.jNote != null) {
                this.jNote.getJingleNoteManager().stopAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trigger(ChipState chip) {
        block15: {
            try {
                if (this.jNote == null) {
                    this.jNote = new JingleNoteComponent();
                }
                this.jNote.enable();
                if (chip.getInput(0) && (this.sequencer == null || this.getSign().getLine(3).equalsIgnoreCase("START"))) {
                    String midiName = this.getSign().getLine(2);
                    int radius = 0;
                    try {
                        radius = Integer.parseInt(this.getSign().getLine(3));
                    }
                    catch (Exception ignored) {
                        // empty catch block
                    }
                    File[] trialPaths = new File[]{new File(CircuitsPlugin.getInst().getDataFolder(), "midi/" + midiName), new File(CircuitsPlugin.getInst().getDataFolder(), "midi/" + midiName + ".mid"), new File(CircuitsPlugin.getInst().getDataFolder(), "midi/" + midiName + ".midi"), new File("midi", midiName), new File("midi", midiName + ".mid"), new File("midi", midiName + ".midi")};
                    File file = null;
                    for (File file2 : trialPaths) {
                        if (!file2.exists()) continue;
                        file = file2;
                        break;
                    }
                    if (file == null) {
                        this.getServer().getLogger().log(Level.SEVERE, "Midi file not found!");
                        return;
                    }
                    if (this.sequencer != null || this.jNote != null) {
                        for (File file3 : this.getServer().getOnlinePlayers()) {
                            if (this.getSign().getLine(3).equalsIgnoreCase("START")) break;
                            this.jNote.getJingleNoteManager().stop((Player)file3);
                        }
                        if (!this.getSign().getLine(3).equalsIgnoreCase("START")) {
                            this.jNote.getJingleNoteManager().stopAll();
                        }
                    }
                    this.sequencer = new MidiJingleSequencer(file);
                    for (File file4 : this.getServer().getOnlinePlayers()) {
                        if (file4 == null || radius > 0 && file4.getLocation().distance(this.getSign().getLocation()) > (double)radius) continue;
                        this.jNote.getJingleNoteManager().play((Player)file4, this.sequencer, 0);
                        file4.sendMessage(ChatColor.YELLOW + "Playing " + midiName + "...");
                    }
                    break block15;
                }
                if (this.sequencer != null && chip.getInput(0) && !this.getSign().getLine(3).equalsIgnoreCase("START")) {
                    if (this.getSign().getLine(3).equalsIgnoreCase("START")) {
                        return;
                    }
                    this.sequencer.stop();
                    this.sequencer = null;
                    for (Player player : this.getServer().getOnlinePlayers()) {
                        this.jNote.getJingleNoteManager().stop(player);
                    }
                    this.jNote.getJingleNoteManager().stopAll();
                }
            }
            catch (Exception e) {
                this.getServer().getLogger().log(Level.SEVERE, "[CraftBookCircuits]: Midi Failed To Play!");
                StringWriter result = new StringWriter();
                PrintWriter printWriter = new PrintWriter(result);
                e.printStackTrace(printWriter);
                this.getServer().getLogger().log(Level.SEVERE, "[CraftBookCircuits]: " + ((Object)result).toString());
            }
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            if (sign.getLine(0).equalsIgnoreCase("POWER SENSOR")) {
                sign.setLine(1, "[MC1266]");
                sign.update();
                return new PowerSensor(this.getServer(), sign);
            }
            return new Melody(this.getServer(), sign);
        }
    }
}

