/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.LocalPlayer;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;

public class MessageSender
extends AbstractIC {
    public MessageSender(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Message Sender";
    }

    public String getSignTitle() {
        return "MESSAGE SENDER";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.sendMessage());
        }
    }

    private boolean sendMessage() {
        boolean sent = false;
        String name = this.getSign().getLine(2);
        String message = this.getSign().getLine(3);
        Player player = this.getServer().getPlayer(name);
        if (player != null) {
            player.sendMessage(message.replace("&", "\u00a7"));
            sent = true;
        } else if (name.equalsIgnoreCase("BROADCAST")) {
            this.getServer().broadcastMessage(message);
        }
        return sent;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new MessageSender(this.getServer(), sign);
        }

        public void checkPlayer(Sign sign, LocalPlayer player) throws ICVerificationException {
            if (!sign.getLine(2).equalsIgnoreCase(player.getName()) && !player.hasPermission("craftbook.ic.restricted.mc1510")) {
                throw new ICVerificationException("You don't have permission to use other players!");
            }
        }
    }
}

