/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.SetDoor;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet61WorldEvent;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;

public class ParticleEffect
extends AbstractIC {
    public ParticleEffect(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Particle Effect";
    }

    public String getSignTitle() {
        return "PARTICLE EFFECT";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.doEffect();
        }
    }

    public void doEffect() {
        try {
            int effectData;
            int effectID = Integer.parseInt(this.getSign().getLine(2).split(":")[0]);
            try {
                effectData = Integer.parseInt(this.getSign().getLine(2).split(":")[1]);
            }
            catch (Exception e) {
                effectData = 0;
            }
            if (effectID == 2001 && Material.getMaterial((int)effectData) == null) {
                return;
            }
            int times = Integer.parseInt(this.getSign().getLine(3));
            Block b = SignUtil.getBackBlock((Block)this.getSign().getBlock());
            for (int i = 0; i < times; ++i) {
                ((CraftServer)this.getServer()).getHandle().sendPacketNearby((double)b.getX(), (double)(b.getY() + 1), (double)b.getZ(), 50.0, ((CraftWorld)this.getSign().getWorld()).getHandle().dimension, (Packet)new Packet61WorldEvent(effectID, b.getX(), b.getY() + 1, b.getZ(), effectData));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            if (sign.getLine(0).equalsIgnoreCase("SET P-DOOR")) {
                sign.setLine(1, "[MC1212]");
                sign.update();
                return new SetDoor(this.getServer(), sign);
            }
            return new ParticleEffect(this.getServer(), sign);
        }
    }
}

