/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Item;

public class Planter
extends AbstractIC {
    public Planter(Server server, Sign block) {
        super(server, block);
    }

    public String getTitle() {
        return "Planter";
    }

    public String getSignTitle() {
        return "PLANTER";
    }

    public void trigger(ChipState chip) {
        int yOffset;
        World world = this.getSign().getWorld();
        Vector onBlock = BukkitUtil.toVector((Location)SignUtil.getBackBlock((Block)this.getSign().getBlock()).getLocation());
        int[] info = null;
        if (this.getSign().getLine(2).length() != 0) {
            String[] lineParts = this.getSign().getLine(2).split(":");
            info = new int[]{Integer.parseInt(lineParts[0]), Integer.parseInt(lineParts[1])};
        }
        if (info == null || !this.plantableItem((int)info[0])) {
            return;
        }
        try {
            yOffset = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (yOffset < 1) {
            return;
        }
        Vector target = onBlock.add(0, yOffset, 0);
        if (world.getBlockTypeIdAt(target.getBlockX(), target.getBlockY(), target.getBlockZ()) == 0 && this.itemPlantableOnBlock(info[0], world.getBlockTypeIdAt(target.getBlockX(), target.getBlockY() - 1, target.getBlockZ()))) {
            saplingPlanter sp = new saplingPlanter(world, target, info[0], info[1]);
            sp.run();
        }
    }

    protected boolean plantableItem(int itemId) {
        boolean isPlantable = false;
        if (itemId == 6 || itemId == 295 || itemId == 372) {
            isPlantable = true;
        }
        return isPlantable;
    }

    protected boolean itemPlantableOnBlock(int itemId, int blockId) {
        boolean isPlantable = false;
        if (itemId == 6 && (blockId == 2 || blockId == 3)) {
            isPlantable = true;
        } else if (itemId == 295 && blockId == 60) {
            isPlantable = true;
        } else if (itemId == 372 && blockId == 88) {
            isPlantable = true;
        }
        return isPlantable;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new Planter(this.getServer(), sign);
        }
    }

    protected class saplingPlanter
    implements Runnable {
        private final World world;
        private final Vector target;
        private final int itemId;
        private final int damVal;

        public saplingPlanter(World world, Vector target, int itemId, int damVal) {
            this.world = world;
            this.target = target;
            this.itemId = itemId;
            this.damVal = damVal;
        }

        public void run() {
            try {
                Collection items = this.world.getEntitiesByClass(Item.class);
                if (items == null) {
                    return;
                }
                for (Item itemEnt : items) {
                    double diffZ;
                    double diffY;
                    double diffX;
                    if (itemEnt.isDead() || itemEnt.getItemStack().getAmount() <= 0 || itemEnt.getItemStack().getTypeId() != this.itemId || this.damVal != -1 && this.damVal != -1 && itemEnt.getItemStack().getDurability() != this.damVal || !((diffX = (double)this.target.getBlockX() - itemEnt.getLocation().getX()) * diffX + (diffY = (double)this.target.getBlockY() - itemEnt.getLocation().getY()) * diffY + (diffZ = (double)this.target.getBlockZ() - itemEnt.getLocation().getZ()) * diffZ < 6.0)) continue;
                    itemEnt.remove();
                    this.world.getBlockAt(this.target.getBlockX(), this.target.getBlockY(), this.target.getBlockZ()).setTypeId(this.getBlockByItem(this.itemId));
                    this.world.getBlockAt(this.target.getBlockX(), this.target.getBlockY(), this.target.getBlockZ()).setData((byte)(this.damVal == -1 ? 0 : this.damVal));
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private int getBlockByItem(int itemId) {
            switch (itemId) {
                case 295: {
                    return 59;
                }
                case 6: {
                    return 6;
                }
                case 372: {
                    return 115;
                }
            }
            return 0;
        }
    }
}

