/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.Planter;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.Vector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class PlanterST
extends Planter
implements SelfTriggeredIC {
    public PlanterST(Server server, Sign block) {
        super(server, block);
    }

    public boolean isActive() {
        return true;
    }

    public String getTitle() {
        return "Self-Triggered Planter";
    }

    public String getSignTitle() {
        return "PLANTER ST";
    }

    public void think(ChipState state) {
        int yOffset;
        World world = this.getSign().getWorld();
        Vector onBlock = BukkitUtil.toVector((Location)SignUtil.getBackBlock((Block)this.getSign().getBlock()).getLocation());
        int[] info = null;
        if (this.getSign().getLine(2).length() != 0) {
            String[] lineParts = this.getSign().getLine(2).split(":");
            info = new int[]{Integer.parseInt(lineParts[0]), Integer.parseInt(lineParts[1])};
        }
        if (info == null || !this.plantableItem((int)info[0])) {
            return;
        }
        try {
            yOffset = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            return;
        }
        if (yOffset < 1) {
            return;
        }
        Vector target = onBlock.add(0, yOffset, 0);
        if (world.getBlockTypeIdAt(target.getBlockX(), target.getBlockY(), target.getBlockZ()) == 0 && this.itemPlantableOnBlock(info[0], world.getBlockTypeIdAt(target.getBlockX(), target.getBlockY() - 1, target.getBlockZ()))) {
            Planter.saplingPlanter sp = new Planter.saplingPlanter(this, world, target, info[0], info[1]);
            sp.run();
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new PlanterST(this.getServer(), sign);
        }
    }
}

