/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import java.util.Set;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerDetection
extends AbstractIC {
    private Block center;
    private Set<Chunk> chunks;
    private int radius = 0;
    private String player = "";
    private String group = "";

    public PlayerDetection(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        Sign sign = this.getSign();
        this.center = this.getSign().getLine(2).contains("=") ? ICUtil.parseBlockLocation(this.getSign()) : SignUtil.getBackBlock((Block)this.getSign().getBlock());
        this.radius = ICUtil.parseRadius(sign);
        String line = sign.getLine(3).trim();
        try {
            if (line.contains("p:")) {
                this.player = line.split(":")[1];
            } else if (line.contains("g:")) {
                this.group = line.split(":")[1];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.chunks = LocationUtil.getSurroundingChunks((Block)this.center, (int)this.radius);
    }

    public String getTitle() {
        return "Player Detection";
    }

    public String getSignTitle() {
        return "P-DETECTION";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isDetected());
        }
    }

    protected boolean isDetected() {
        for (Chunk chunk : this.chunks) {
            if (!chunk.isLoaded()) continue;
            for (Entity entity : chunk.getEntities()) {
                if (entity.isDead() || !entity.isValid() || !(entity instanceof Player) || !LocationUtil.isWithinRadius((Location)this.center.getLocation(), (Location)entity.getLocation(), (int)this.radius)) continue;
                if (!this.player.equals("")) {
                    return ((Player)entity).getName().equals(this.player);
                }
                if (!this.group.equals("")) {
                    return CircuitsPlugin.getInst().isInGroup(((Player)entity).getName(), this.group);
                }
                return true;
            }
        }
        return false;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new PlayerDetection(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

