/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.PlayerDetection;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class PlayerDetectionST
extends PlayerDetection
implements SelfTriggeredIC {
    public PlayerDetectionST(Server server, Sign block) {
        super(server, block);
    }

    public String getTitle() {
        return "Self Triggered Player Detection";
    }

    public String getSignTitle() {
        return "ST P-DETECTION";
    }

    public void think(ChipState state) {
        state.setOutput(0, this.isDetected());
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new PlayerDetectionST(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

