/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionInducer
extends AbstractIC
implements SelfTriggeredIC {
    public PotionInducer(Server server, Sign sign) {
        super(server, sign);
    }

    public boolean isActive() {
        return true;
    }

    public String getTitle() {
        return "Potion Inducer";
    }

    public String getSignTitle() {
        return "POTION INDUCER";
    }

    public void trigger(ChipState chip) {
    }

    public void think(ChipState state) {
        if (state.getInput(0)) {
            for (Player p : this.getSign().getWorld().getPlayers()) {
                int radius = 10;
                int effectID = 1;
                int effectAmount = 1;
                int effectTime = 10;
                try {
                    effectID = Integer.parseInt(this.getSign().getLine(2).split(":")[0]);
                    effectAmount = Integer.parseInt(this.getSign().getLine(2).split(":")[1]);
                    effectTime = Integer.parseInt(this.getSign().getLine(2).split(":")[2]);
                    radius = Integer.parseInt(this.getSign().getLine(3));
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                if (p.getLocation().distance(this.getSign().getLocation()) > (double)radius) continue;
                p.addPotionEffect(new PotionEffect(PotionEffectType.getById((int)effectID), effectTime * 20, effectAmount - 1), true);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new PotionInducer(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            try {
                int effectId = Integer.parseInt(sign.getLine(2).split(":")[0]);
                if (PotionEffectType.getById((int)effectId) == null) {
                    throw new ICVerificationException("The third line must be a valid potion effect id.");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("The third line must be a valid potion effect id.");
            }
        }
    }
}

