/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class PowerSensor
extends AbstractIC {
    private Block center;

    public PowerSensor(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        this.center = ICUtil.parseBlockLocation(this.getSign());
    }

    public String getTitle() {
        return "Power Sensor";
    }

    public String getSignTitle() {
        return "POWER SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.isPowered());
        }
    }

    protected boolean isPowered() {
        return this.center.isBlockPowered() || this.center.isBlockIndirectlyPowered();
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new PowerSensor(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

