/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.gates.world.PowerSensor;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class PowerSensorST
extends PowerSensor
implements SelfTriggeredIC {
    public PowerSensorST(Server server, Sign block) {
        super(server, block);
    }

    public String getTitle() {
        return "Self Triggered Power Sensor";
    }

    public String getSignTitle() {
        return "ST POWER SENSOR";
    }

    public void think(ChipState state) {
        state.setOutput(0, this.isPowered());
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            if (sign.getLine(1).equalsIgnoreCase("[MC0270]")) {
                sign.setLine(1, "[MC0266]");
                sign.update();
            }
            return new PowerSensorST(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

