/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;
import org.bukkit.block.Sign;

public class RangedOutput
extends AbstractIC
implements SelfTriggeredIC {
    int ticks = 0;
    int maxTicks = 0;
    boolean hasStarted = false;
    int amountDone = 0;
    int maxAmount = 0;

    public RangedOutput(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Ranged Output";
    }

    public String getSignTitle() {
        return "RANGE OUTPUT";
    }

    public void think(ChipState chip) {
        chip.setOutput(0, this.shouldOutput(chip));
    }

    protected boolean shouldOutput(ChipState chip) {
        if (chip.getInput(0)) {
            int min = Integer.parseInt(this.getSign().getLine(2).split("-")[0]);
            int max = Integer.parseInt(this.getSign().getLine(2).split("-")[1]);
            this.maxAmount = min + (int)(Math.random() * (double)(max - min + 1));
            this.amountDone = 0;
            this.ticks = 0;
            this.maxTicks = this.getSign().getLine(3) != null || this.getSign().getLine(3).equals("") ? Integer.parseInt(this.getSign().getLine(3)) : 10;
            this.hasStarted = true;
            return false;
        }
        if (this.hasStarted) {
            if (this.ticks >= this.maxTicks) {
                this.ticks = 0;
                ++this.amountDone;
                if (this.amountDone >= this.maxAmount) {
                    this.hasStarted = false;
                    this.amountDone = 0;
                    this.ticks = 0;
                    this.maxAmount = 0;
                }
                return true;
            }
            ++this.ticks;
            return false;
        }
        return false;
    }

    public boolean isActive() {
        return true;
    }

    public void trigger(ChipState chip) {
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new RangedOutput(this.getServer(), sign);
        }
    }
}

