/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.EnumUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;

public class SentryGun
extends AbstractIC {
    private Type type;
    private Block center;
    private int radius = 10;

    public SentryGun(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        this.type = Type.fromString(this.getSign().getLine(2));
        this.center = SignUtil.getBackBlock((Block)this.getSign().getBlock());
        this.radius = Integer.parseInt(this.getSign().getLine(3));
    }

    public String getTitle() {
        return "Sentry Gun";
    }

    public String getSignTitle() {
        return "SENTRY GUN";
    }

    public void trigger(ChipState chip) {
        this.shoot();
    }

    public void shoot() {
        for (Entity aEntity : this.center.getWorld().getEntities()) {
            if (aEntity.isDead() || !aEntity.isValid() || !this.type.is(aEntity) || !(aEntity.getLocation().distanceSquared(this.center.getLocation()) <= (double)(this.radius * this.radius))) continue;
            Block signBlock = this.getSign().getBlock();
            BlockFace face = SignUtil.getBack((Block)signBlock);
            Block targetDir = signBlock.getRelative(face).getRelative(face);
            this.center.getWorld().spawnArrow(targetDir.getLocation(), aEntity.getLocation().subtract(targetDir.getLocation()).add(0.5, 0.5, 0.5).toVector(), 2.0f, 0.0f);
            break;
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new SentryGun(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            try {
                String line = sign.getLine(3);
                if (line != null && !line.contains("")) {
                    Integer.parseInt(line);
                }
            }
            catch (Exception e) {
                throw new ICVerificationException("You need to give a radius in line four.");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        PLAYER,
        MOB_HOSTILE,
        MOB_PEACEFUL,
        MOB_ANY;


        public boolean is(Entity entity) {
            switch (this) {
                case PLAYER: {
                    return entity instanceof Player;
                }
                case MOB_HOSTILE: {
                    return entity instanceof Monster;
                }
                case MOB_PEACEFUL: {
                    return entity instanceof Animals;
                }
                case MOB_ANY: {
                    return entity instanceof Creature;
                }
            }
            return entity instanceof Monster;
        }

        public static Type fromString(String name) {
            return (Type)EnumUtil.getEnumFromString(Type.class, (String)name);
        }
    }
}

