/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.block.Sign;
import org.bukkit.inventory.ItemStack;

public class SetBlockAboveChest
extends AbstractIC {
    public SetBlockAboveChest(Server server, Sign sign) {
        super(server, sign);
    }

    public String getTitle() {
        return "Set Block Above";
    }

    public String getSignTitle() {
        return "SET BLOCK ABOVE";
    }

    public void trigger(ChipState chip) {
        String sblockdat = this.getSign().getLine(2).toUpperCase().trim();
        String sblock = sblockdat.split(":")[0];
        String smeta = "";
        if (sblockdat.split(":").length > 1) {
            smeta = sblockdat.split(":")[1];
        }
        String force = this.getSign().getLine(3).toUpperCase().trim();
        chip.setOutput(0, chip.getInput(0));
        int block = -1;
        try {
            block = Integer.parseInt(sblock);
        }
        catch (Exception e) {
            return;
        }
        byte meta = -1;
        try {
            if (!smeta.equalsIgnoreCase("")) {
                meta = Byte.parseByte(smeta);
            }
        }
        catch (Exception e) {
            return;
        }
        Block body = SignUtil.getBackBlock((Block)this.getSign().getBlock());
        int x = body.getX();
        int y = body.getY();
        int z = body.getZ();
        if ((force.equals("FORCE") || body.getWorld().getBlockAt(x, y + 1, z).getType() == Material.AIR) && this.takeFromChest(x, y - 1, z, block, meta)) {
            body.getWorld().getBlockAt(x, y + 1, z).setTypeId(block);
            if (meta != -1) {
                body.getWorld().getBlockAt(x, y + 1, z).setData(meta);
            }
        }
    }

    public boolean takeFromChest(int x, int y, int z, int id, byte data) {
        boolean ret = false;
        Block bl = this.getSign().getBlock().getWorld().getBlockAt(x, y, z);
        if (bl.getType() == Material.CHEST) {
            Chest c = (Chest)bl.getState();
            ItemStack[] is = c.getInventory().getContents();
            for (int i = 0; i < is.length; i = (int)((short)(i + 1))) {
                if (is[i] == null || is[i].getAmount() <= 0 || is[i].getTypeId() != id || data != -1 && is[i].getData().getData() != data) continue;
                ItemStack stack = is[i];
                this.getSign().getWorld().dropItemNaturally(new Location(this.getSign().getWorld(), (double)x, (double)y, (double)z), stack);
                if (is[i].getAmount() == 1) {
                    is[i] = new ItemStack(0, 0);
                } else {
                    is[i].setAmount(is[i].getAmount() - 1);
                }
                ret = true;
                break;
            }
            c.getInventory().setContents(is);
        }
        return ret;
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new SetBlockAboveChest(this.getServer(), sign);
        }
    }
}

