/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.RestrictedIC;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class SetDoor
extends AbstractIC {
    private int onMaterial = 1;
    private int onData = 0;
    private int offMaterial = 0;
    private int offData = 0;
    private int width = 1;
    private int height = 1;
    private int offsetX = 0;
    private int offsetY = 0;
    private int offsetZ = 0;
    private Block center;
    private BlockFace faceing;

    public SetDoor(Server server, Sign block) {
        super(server, block);
        this.load();
    }

    private void load() {
        this.center = SignUtil.getBackBlock((Block)this.getSign().getBlock());
        this.faceing = SignUtil.getFacing((Block)this.getSign().getBlock());
        String line = this.getSign().getLine(2);
        if (!line.equals("")) {
            try {
                String[] strings;
                String[] split = line.split("-");
                if (split.length > 0) {
                    try {
                        strings = split[1].split(":");
                        this.offMaterial = Integer.parseInt(strings[0]);
                        if (strings.length > 0) {
                            this.offData = Integer.parseInt(strings[1]);
                        }
                    }
                    catch (NumberFormatException e) {
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        // empty catch block
                    }
                }
                strings = split[0].split(":");
                this.onMaterial = Integer.parseInt(strings[0]);
                if (strings.length > 0) {
                    this.onData = Integer.parseInt(strings[1]);
                }
            }
            catch (NumberFormatException e) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (!(line = this.getSign().getLine(3)).equals("")) {
            boolean relativeOffset;
            boolean bl = relativeOffset = !line.contains("!");
            if (!relativeOffset) {
                line.replace("!", "");
            }
            String[] split = line.split(":");
            try {
                String[] offsetSplit = split[0].split(",");
                this.offsetX = Integer.parseInt(offsetSplit[0]);
                this.offsetY = Integer.parseInt(offsetSplit[1]);
                this.offsetZ = Integer.parseInt(offsetSplit[2]);
            }
            catch (NumberFormatException e) {
            }
            catch (IndexOutOfBoundsException e) {
                // empty catch block
            }
            try {
                String[] sizeSplit = split[1].split(",");
                this.width = Integer.parseInt(sizeSplit[0]);
                this.height = Integer.parseInt(sizeSplit[1]);
            }
            catch (NumberFormatException e) {
            }
            catch (ArrayIndexOutOfBoundsException e) {
                // empty catch block
            }
            this.center = relativeOffset ? LocationUtil.getRelativeOffset((Sign)this.getSign(), (int)this.offsetX, (int)this.offsetY, (int)this.offsetZ) : LocationUtil.getOffset((Block)this.center, (int)this.offsetX, (int)this.offsetY, (int)this.offsetZ);
        } else {
            this.center = this.center.getRelative(BlockFace.UP);
        }
    }

    public String getTitle() {
        return "Set P-Door";
    }

    public String getSignTitle() {
        return "SET P-DOOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            this.setDoor(true);
        } else {
            this.setDoor(false);
        }
    }

    private void setDoor(boolean open) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                Block block = LocationUtil.getRelativeOffset((Block)this.center, (BlockFace)this.faceing, (int)x, (int)y, (int)0);
                if (open) {
                    block.setTypeIdAndData(this.onMaterial, (byte)this.onData, true);
                    continue;
                }
                block.setTypeIdAndData(this.offMaterial, (byte)this.offData, true);
            }
        }
    }

    public static class Factory
    extends AbstractICFactory
    implements RestrictedIC {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new SetDoor(this.getServer(), sign);
        }
    }
}

