/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.world;

import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.block.Sign;

public class WaterSensor
extends AbstractIC {
    Block center;

    public WaterSensor(Server server, Sign sign) {
        super(server, sign);
        this.center = ICUtil.parseBlockLocation(sign);
    }

    public String getTitle() {
        return "Water Sensor";
    }

    public String getSignTitle() {
        return "WATER SENSOR";
    }

    public void trigger(ChipState chip) {
        if (chip.getInput(0)) {
            chip.setOutput(0, this.hasWater());
        }
    }

    protected boolean hasWater() {
        int blockID = this.center.getTypeId();
        return blockID == 8 || blockID == 9;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(Sign sign) {
            return new WaterSensor(this.getServer(), sign);
        }

        public void verify(Sign sign) throws ICVerificationException {
            ICUtil.verifySignSyntax(sign);
        }
    }
}

