/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICFamily;
import com.sk89q.craftbook.ic.RegisteredICFactory;
import com.sk89q.worldedit.BlockWorldVector;
import java.util.HashMap;
import java.util.Map;

public class ICManager {
    protected final Map<String, RegisteredICFactory> registered = new HashMap<String, RegisteredICFactory>();
    private static final Map<BlockWorldVector, IC> cachedICs = new HashMap<BlockWorldVector, IC>();

    public void register(String id, ICFactory factory, ICFamily ... families) {
        for (ICFamily family : families) {
            id = id.replace("MC", family.getModifier());
            RegisteredICFactory registration = new RegisteredICFactory(id, factory, family);
            this.registered.put(id.toLowerCase(), registration);
        }
    }

    public RegisteredICFactory get(String id) {
        return this.registered.get(id.toLowerCase());
    }

    public static boolean isCachedIC(BlockWorldVector pt) {
        return cachedICs.containsKey(pt);
    }

    public static IC getCachedIC(BlockWorldVector pt) {
        return cachedICs.get(pt);
    }

    public static void addCachedIC(BlockWorldVector pt, IC ic) {
        cachedICs.put(pt, ic);
    }

    public static IC removeCachedIC(BlockWorldVector pt) {
        if (cachedICs.containsKey(pt)) {
            return cachedICs.remove(pt);
        }
        return null;
    }

    public static void unloadIC(BlockWorldVector pt) {
        ICManager.removeCachedIC(pt);
    }
}

