/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic;

import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.util.LocationUtil;
import com.sk89q.craftbook.util.SignUtil;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.material.Lever;
import org.bukkit.material.PistonBaseMaterial;

public class ICUtil {
    private static BlockFace[] REDSTONE_CONTACT_FACES = new BlockFace[]{BlockFace.DOWN, BlockFace.EAST, BlockFace.WEST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.UP};

    private ICUtil() {
    }

    public static boolean setState(Block block, boolean state) {
        if (block.getType() != Material.LEVER) {
            return false;
        }
        boolean wasOn = (block.getData() & 8) > 0;
        byte data = block.getData();
        Lever lever = (Lever)block.getState().getData();
        int newData = !state ? data & 7 : data | 8;
        if (wasOn != state) {
            try {
                net.minecraft.server.Block nmsBlock = net.minecraft.server.Block.byId[Material.LEVER.getId()];
                WorldServer nmsWorld = ((CraftWorld)block.getWorld()).getHandle();
                nmsBlock.interact((World)nmsWorld, block.getX(), block.getY(), block.getZ(), null, 0, 0.0f, 0.0f, 0.0f);
                return true;
            }
            catch (Throwable e) {
                block.setData((byte)newData, true);
                Block source = block.getRelative(lever.getAttachedFace());
                for (BlockFace face : REDSTONE_CONTACT_FACES) {
                    Block relative = source.getRelative(face);
                    Material type = relative.getType();
                    data = relative.getData();
                    newData = state ? data | 8 : data & 0xFFFFFFF7;
                    if (type == Material.REDSTONE_WIRE || type == Material.POWERED_RAIL) {
                        relative.setData((byte)newData, true);
                        continue;
                    }
                    if (type == Material.REDSTONE_LAMP_OFF || type == Material.REDSTONE_LAMP_ON) {
                        if (state) {
                            relative.setType(Material.REDSTONE_LAMP_ON);
                            continue;
                        }
                        relative.setType(Material.REDSTONE_LAMP_OFF);
                        continue;
                    }
                    if (type == Material.REDSTONE_TORCH_ON || type == Material.REDSTONE_TORCH_OFF) {
                        if (state) {
                            relative.setType(Material.REDSTONE_TORCH_OFF);
                            continue;
                        }
                        relative.setType(Material.REDSTONE_TORCH_ON);
                        continue;
                    }
                    if (type == Material.PISTON_BASE || type == Material.PISTON_STICKY_BASE) {
                        ((PistonBaseMaterial)relative.getState().getData()).setPowered(state);
                        relative.getState().update();
                        continue;
                    }
                    if (type != Material.LEVER) continue;
                    relative.setData((byte)newData, true);
                }
                return true;
            }
        }
        return false;
    }

    public static Block parseBlockLocation(Sign sign, int lPos, boolean relative) {
        String[] split;
        Block target = SignUtil.getBackBlock((Block)sign.getBlock());
        String line = sign.getLine(lPos);
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        if (line.contains("=")) {
            split = line.split("=");
            line = split[1];
        }
        try {
            split = line.split(":");
            if (split.length > 1) {
                offsetX = Integer.parseInt(split[0]);
                offsetY = Integer.parseInt(split[1]);
                offsetZ = Integer.parseInt(split[2]);
            } else {
                offsetY = Integer.parseInt(line);
            }
        }
        catch (NumberFormatException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        target = relative ? LocationUtil.getRelativeOffset((Sign)sign, (int)offsetX, (int)offsetY, (int)offsetZ) : LocationUtil.getOffset((Block)target, (int)offsetX, (int)offsetY, (int)offsetZ);
        return target;
    }

    public static Block parseBlockLocation(Sign sign, int lPos) {
        return ICUtil.parseBlockLocation(sign, lPos, true);
    }

    public static Block parseBlockLocation(Sign sign) {
        return ICUtil.parseBlockLocation(sign, 2, true);
    }

    public static void verifySignSyntax(Sign sign) throws ICVerificationException {
        ICUtil.verifySignSyntax(sign, 2);
    }

    public static void verifySignSyntax(Sign sign, int i) throws ICVerificationException {
        try {
            String line = sign.getLine(i);
            String[] strings = line.split(":");
            if (line.contains("=")) {
                String[] split = line.split("=");
                Integer.parseInt(split[0]);
                strings = split[1].split(":");
            }
            if (strings.length > 1) {
                Integer.parseInt(strings[1]);
                Integer.parseInt(strings[2]);
            }
            Integer.parseInt(strings[0]);
        }
        catch (Exception e) {
            throw new ICVerificationException("Wrong syntax! Needs to be: radius=x:y:z or radius=y or y");
        }
    }

    public static int parseRadius(Sign sign) {
        return ICUtil.parseRadius(sign, 2);
    }

    public static int parseRadius(Sign sign, int lPos) {
        String line = sign.getLine(lPos);
        int radius = 0;
        try {
            return Integer.parseInt(line.split("=")[0]);
        }
        catch (NumberFormatException e) {
            return radius;
        }
    }
}

