/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic.families;

import com.sk89q.craftbook.ic.AbstractChipState;
import com.sk89q.craftbook.ic.AbstractICFamily;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class Family3ISO
extends AbstractICFamily {
    public ChipState detect(BlockWorldVector source, Sign sign) {
        return new ChipState3ISO(source, sign);
    }

    public static class ChipState3ISO
    extends AbstractChipState {
        public ChipState3ISO(BlockWorldVector source, Sign sign) {
            super(source, sign);
        }

        protected Block getBlock(int pin) {
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock((Block)this.sign.getBlock());
                }
                case 1: {
                    return SignUtil.getLeftBlock((Block)this.sign.getBlock());
                }
                case 2: {
                    return SignUtil.getRightBlock((Block)this.sign.getBlock());
                }
                case 3: {
                    BlockFace face = SignUtil.getBack((Block)this.sign.getBlock());
                    return this.sign.getBlock().getRelative(face).getRelative(face);
                }
            }
            return null;
        }

        public boolean get(int pin) {
            Block block = this.getBlock(pin);
            return block != null && block.isBlockIndirectlyPowered();
        }

        public void set(int pin, boolean value) {
            Block block = this.getBlock(pin);
            if (block != null) {
                ICUtil.setState(block, value);
            }
        }

        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 3);
        }

        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 3, value);
        }

        public int getInputCount() {
            return 3;
        }

        public int getOutputCount() {
            return 1;
        }
    }
}

