/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic.families;

import com.sk89q.craftbook.ic.AbstractChipState;
import com.sk89q.craftbook.ic.AbstractICFamily;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class FamilySI3O
extends AbstractICFamily {
    public ChipState detect(BlockWorldVector source, Sign sign) {
        return new ChipStateSI3O(source, sign);
    }

    public static class ChipStateSI3O
    extends AbstractChipState {
        public ChipStateSI3O(BlockWorldVector source, Sign sign) {
            super(source, sign);
        }

        protected Block getBlock(int pin) {
            Block bsign = this.sign.getBlock();
            BlockFace fback = SignUtil.getBack((Block)bsign);
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock((Block)bsign);
                }
                case 1: {
                    return bsign.getRelative(fback).getRelative(fback);
                }
                case 2: {
                    return bsign.getRelative(fback).getRelative(SignUtil.getCounterClockWise((BlockFace)fback));
                }
                case 3: {
                    return bsign.getRelative(fback).getRelative(SignUtil.getClockWise((BlockFace)fback));
                }
            }
            return null;
        }

        public boolean get(int pin) {
            Block block = this.getBlock(pin);
            return block != null && block.isBlockIndirectlyPowered();
        }

        public void set(int pin, boolean value) {
            Block block = this.getBlock(pin);
            if (block != null) {
                ICUtil.setState(block, value);
            }
        }

        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 1);
        }

        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 1, value);
        }

        public int getInputCount() {
            return 1;
        }

        public int getOutputCount() {
            return 3;
        }
    }
}

