/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.ic.families;

import com.sk89q.craftbook.ic.AbstractChipState;
import com.sk89q.craftbook.ic.AbstractICFamily;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.util.SignUtil;
import com.sk89q.worldedit.BlockWorldVector;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.Sign;

public class FamilySISO
extends AbstractICFamily {
    public ChipState detect(BlockWorldVector source, Sign sign) {
        return new ChipStateSISO(source, sign);
    }

    public static class ChipStateSISO
    extends AbstractChipState {
        public ChipStateSISO(BlockWorldVector source, Sign sign) {
            super(source, sign);
        }

        protected Block getBlock(int pin) {
            switch (pin) {
                case 0: {
                    return SignUtil.getFrontBlock((Block)this.sign.getBlock());
                }
                case 1: {
                    BlockFace face = SignUtil.getBack((Block)this.sign.getBlock());
                    return this.sign.getBlock().getRelative(face).getRelative(face);
                }
            }
            return null;
        }

        public boolean get(int pin) {
            Block block = this.getBlock(pin);
            return block != null && block.isBlockIndirectlyPowered();
        }

        public void set(int pin, boolean value) {
            Block block = this.getBlock(pin);
            if (block != null) {
                ICUtil.setState(block, value);
            }
        }

        public boolean getInput(int inputIndex) {
            return this.get(inputIndex);
        }

        public boolean getOutput(int outputIndex) {
            return this.get(outputIndex + 1);
        }

        public void setOutput(int outputIndex, boolean value) {
            this.set(outputIndex + 1, value);
        }

        public int getInputCount() {
            return 1;
        }

        public int getOutputCount() {
            return 1;
        }
    }
}

