/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.jinglenote.JingleNotePlayer;
import com.sk89q.jinglenote.MidiJingleSequencer;
import com.sk89q.worldedit.blocks.BlockType;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class JingleNoteManager {
    protected final Map<String, JingleNotePlayer> instances = new HashMap<String, JingleNotePlayer>();

    public void play(Player player, MidiJingleSequencer sequencer, int delay) {
        String name = player.getName();
        Location loc = this.findLocation(player);
        if (this.instances.containsKey(name)) {
            JingleNotePlayer existing;
            Location existingLoc = (existing = this.instances.get(name)).getLocation();
            existing.stop(existingLoc.getBlockX() == loc.getBlockX() && existingLoc.getBlockY() == loc.getBlockY() && existingLoc.getBlockZ() == loc.getBlockZ());
            this.instances.remove(name);
        }
        JingleNotePlayer notePlayer = new JingleNotePlayer(player, loc, sequencer, delay);
        Thread thread = new Thread(notePlayer);
        thread.setName("JingleNotePlayer for " + player.getName());
        thread.start();
        this.instances.put(name, notePlayer);
    }

    public boolean stop(Player player) {
        String name = player.getName();
        if (this.instances.containsKey(name)) {
            JingleNotePlayer existing = this.instances.get(name);
            existing.stop(false);
            this.instances.remove(name);
            return true;
        }
        return false;
    }

    public void stopAll() {
        for (JingleNotePlayer notePlayer : this.instances.values()) {
            notePlayer.stop(false);
        }
        this.instances.clear();
    }

    private Location findLocation(Player player) {
        World world = player.getWorld();
        Location loc = player.getLocation();
        loc.setY(loc.getY() - 2.0);
        if (!BlockType.canPassThrough((int)world.getBlockTypeIdAt(loc))) {
            return loc;
        }
        loc.setY(loc.getY() + 4.0);
        return loc;
    }
}

