/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.jinglenote;

import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.jinglenote.MidiJingleSequencer;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class JingleNotePlayer
implements Runnable {
    protected final Player player;
    protected final Location loc;
    protected MidiJingleSequencer sequencer;
    protected final int delay;
    protected boolean keepMusicBlock = false;

    public JingleNotePlayer(Player player, Location loc, MidiJingleSequencer seq, int delay) {
        this.player = player;
        this.loc = loc;
        this.sequencer = seq;
        this.delay = delay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.delay > 0) {
                Thread.sleep(this.delay);
            }
            this.player.sendBlockChange(this.loc, 25, (byte)0);
            Thread.sleep(100L);
            try {
                this.sequencer.run(this);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            Thread.sleep(500L);
            if (!this.keepMusicBlock) {
                CircuitsPlugin.server.getScheduler().scheduleSyncDelayedTask((Plugin)CircuitsPlugin.getInst(), new Runnable(){

                    public void run() {
                        int prevId = JingleNotePlayer.this.player.getWorld().getBlockTypeIdAt(JingleNotePlayer.this.loc);
                        byte prevData = JingleNotePlayer.this.player.getWorld().getBlockAt(JingleNotePlayer.this.loc).getData();
                        JingleNotePlayer.this.player.sendBlockChange(JingleNotePlayer.this.loc, prevId, prevData);
                    }
                });
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.sequencer.stop();
            this.sequencer = null;
        }
    }

    public boolean isActive() {
        return this.player.isOnline();
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.loc;
    }

    public void stop(boolean keepMusicBlock) {
        this.keepMusicBlock = keepMusicBlock;
        if (this.sequencer != null) {
            this.sequencer.stop();
        }
        CircuitsPlugin.server.getScheduler().scheduleSyncDelayedTask((Plugin)CircuitsPlugin.getInst(), new Runnable(){

            public void run() {
                int prevId = JingleNotePlayer.this.player.getWorld().getBlockTypeIdAt(JingleNotePlayer.this.loc);
                byte prevData = JingleNotePlayer.this.player.getWorld().getBlockAt(JingleNotePlayer.this.loc).getData();
                JingleNotePlayer.this.player.sendBlockChange(JingleNotePlayer.this.loc, prevId, prevData);
            }
        });
    }

    public void play(byte instrument, byte note) {
        if (!this.player.isOnline()) {
            return;
        }
        this.player.playNote(this.loc, instrument, note);
    }
}

