/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.circuits;

import com.sk89q.craftbook.AbstractMechanicFactory;
import com.sk89q.craftbook.PersistentMechanic;
import com.sk89q.craftbook.SourcedBlockRedstoneEvent;
import com.sk89q.craftbook.bukkit.CircuitsPlugin;
import com.sk89q.worldedit.BlockWorldVector;
import com.sk89q.worldedit.WorldVector;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import java.util.Arrays;
import java.util.List;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlowStone
extends PersistentMechanic {
    CircuitsPlugin plugin;
    BlockWorldVector pt;

    private GlowStone(BlockWorldVector pt, CircuitsPlugin plugin) {
        this.plugin = plugin;
        this.pt = pt;
    }

    public void onBlockRedstoneChange(SourcedBlockRedstoneEvent event) {
        if (event.getNewCurrent() > 0) {
            event.getBlock().setTypeId(89);
        } else {
            event.getBlock().setTypeId(this.plugin.getLocalConfiguration().glowstoneOffBlock);
        }
        event.getBlock().setData(event.getBlock().getData(), false);
    }

    public boolean isActive() {
        return BukkitUtil.toBlock((BlockWorldVector)this.pt).getTypeId() == 89;
    }

    public void onBlockBreak(BlockBreakEvent event) {
        if (event.getBlock().getTypeId() == 89 && (event.getBlock().isBlockIndirectlyPowered() || event.getBlock().isBlockPowered())) {
            event.setCancelled(true);
        }
    }

    public List<BlockWorldVector> getWatchedPositions() {
        return Arrays.asList(this.pt);
    }

    public void onWatchBlockNotification(BlockEvent evt) {
        if (evt instanceof BlockBreakEvent && evt.getBlock().getTypeId() == 89 && (evt.getBlock().isBlockIndirectlyPowered() || evt.getBlock().isBlockPowered())) {
            ((BlockBreakEvent)evt).setCancelled(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractMechanicFactory<GlowStone> {
        CircuitsPlugin plugin;

        public Factory(CircuitsPlugin plugin) {
            this.plugin = plugin;
        }

        public GlowStone detect(BlockWorldVector pt) {
            int type = BukkitUtil.toWorld((WorldVector)pt).getBlockTypeIdAt(BukkitUtil.toLocation((WorldVector)pt));
            if (type == this.plugin.getLocalConfiguration().glowstoneOffBlock || type == 89) {
                return new GlowStone(pt, this.plugin);
            }
            return null;
        }
    }
}

