/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICVerificationException;
import org.apache.commons.lang.ArrayUtils;
import org.bukkit.Server;

public class CombinationLock
extends AbstractIC {
    public CombinationLock(Server server, ChangedSign block, ICFactory factory) {
        super(server, block, factory);
    }

    public String getTitle() {
        return "Combination Lock";
    }

    public String getSignTitle() {
        return "COMBINATION LOCK";
    }

    public void trigger(ChipState state) {
        try {
            Character[] data = ArrayUtils.toObject((char[])this.getSign().getLine(2).toCharArray());
            if (state.getInput(0) == (data[1].charValue() == 'X') && state.getInput(1) == (data[2].charValue() == 'X') && state.getInput(2) == (data[0].charValue() == 'X')) {
                state.setOutput(0, true);
                return;
            }
            state.setOutput(0, false);
        }
        catch (Exception e) {
            state.setOutput(0, false);
        }
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new CombinationLock(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            if (sign.getLine(2) == null && sign.getLine(2).isEmpty()) {
                throw new ICVerificationException("Line three needs to be a combination");
            }
        }

        public String getDescription() {
            return "Checks combination on sign against inputs.";
        }

        public String[] getLineHelp() {
            String[] lines = new String[]{"Combination. X = On, O = Off (XOX)", null};
            return lines;
        }
    }
}

