/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.craftbook.gates.logic;

import com.sk89q.craftbook.ChangedSign;
import com.sk89q.craftbook.ic.AbstractIC;
import com.sk89q.craftbook.ic.AbstractICFactory;
import com.sk89q.craftbook.ic.ChipState;
import com.sk89q.craftbook.ic.IC;
import com.sk89q.craftbook.ic.ICFactory;
import com.sk89q.craftbook.ic.ICUtil;
import com.sk89q.craftbook.ic.ICVerificationException;
import com.sk89q.craftbook.ic.SelfTriggeredIC;
import org.bukkit.Server;

public class Monostable
extends AbstractIC
implements SelfTriggeredIC {
    public Monostable(Server server, ChangedSign psign, ICFactory factory) {
        super(server, psign, factory);
    }

    public String getTitle() {
        return "Monostable";
    }

    public String getSignTitle() {
        return "MONOSTABLE";
    }

    public void trigger(ChipState chip) {
        String setting = this.getSign().getLine(2).toUpperCase();
        if (chip.getInput(0) && setting.contains("H") || !chip.getInput(0) && setting.contains("L")) {
            int colon = setting.indexOf(58);
            if (colon <= 0) {
                return;
            }
            chip.setOutput(0, true);
            this.getSign().setLine(3, setting.substring(0, colon));
        }
    }

    public void think(ChipState chip) {
        int tick;
        try {
            tick = Integer.parseInt(this.getSign().getLine(3));
        }
        catch (NumberFormatException e) {
            tick = 0;
        }
        if (tick == 0) {
            chip.setOutput(0, false);
        } else {
            --tick;
        }
        this.getSign().setLine(3, Integer.toString(tick));
    }

    public boolean isActive() {
        return true;
    }

    public static class Factory
    extends AbstractICFactory {
        public Factory(Server server) {
            super(server);
        }

        public IC create(ChangedSign sign) {
            return new Monostable(this.getServer(), sign, this);
        }

        public void verify(ChangedSign sign) throws ICVerificationException {
            boolean lo;
            boolean hi;
            int ticks;
            try {
                String set = sign.getLine(2).toUpperCase();
                if (!set.contains(":")) {
                    throw new ICVerificationException("Invalid syntax");
                }
                String[] settings = ICUtil.COLON_PATTERN.split(set);
                if (settings.length != 2) {
                    throw new ICVerificationException("Invalid syntax");
                }
                ticks = Integer.parseInt(settings[0]);
                hi = settings[1].contains("H");
                lo = settings[1].contains("L");
                if (!hi && !lo) {
                    throw new ICVerificationException("Missing trigger levels");
                }
            }
            catch (NumberFormatException e) {
                throw new ICVerificationException("Invalid number format");
            }
            ticks = Math.max(ticks, 10);
            ticks = Math.min(ticks, 50);
            sign.setLine(2, Integer.toString(ticks) + ":" + (hi ? "H" : "") + (lo ? "L" : ""));
            sign.setLine(3, "0");
            sign.update(false);
        }
    }
}

